/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv;

import ai.djl.modality.cv.output.BoundingBox;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.modality.cv.output.Joints;
import ai.djl.modality.cv.output.Point;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDManager;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public interface Image {
    public int getWidth();

    public int getHeight();

    public Object getWrappedImage();

    public Image resize(int var1, int var2, boolean var3);

    public Image getMask(int[][] var1);

    public Image getSubImage(int var1, int var2, int var3, int var4);

    public Image duplicate();

    default public NDArray toNDArray(NDManager manager) {
        return this.toNDArray(manager, null);
    }

    public NDArray toNDArray(NDManager var1, Flag var2);

    public void save(OutputStream var1, String var2) throws IOException;

    public List<BoundingBox> findBoundingBoxes();

    default public void drawBoundingBoxes(DetectedObjects detections) {
        this.drawBoundingBoxes(detections, -1.0f);
    }

    public void drawBoundingBoxes(DetectedObjects var1, float var2);

    default public void drawMarks(List<Point> points) {
        int w = this.getWidth();
        int h = this.getHeight();
        int size = Math.min(w, h) / 50;
        this.drawMarks(points, size);
    }

    public void drawMarks(List<Point> var1, int var2);

    public void drawJoints(Joints var1);

    public void drawImage(Image var1, boolean var2);

    default public int[][] createStar(Point point, int radius) {
        int[][] ret = new int[2][10];
        double midX = point.getX();
        double midY = point.getY();
        double[] ratio = new double[]{radius, (double)radius * 0.38196601125};
        double delta = 0.6283185307179586;
        for (int i = 0; i < 10; ++i) {
            double angle = (double)i * delta;
            double r = ratio[i % 2];
            double x = Math.cos(angle) * r;
            double y = Math.sin(angle) * r;
            ret[0][i] = (int)(x + midX);
            ret[1][i] = (int)(y + midY);
        }
        return ret;
    }

    public static enum Flag {
        GRAYSCALE,
        COLOR;


        public int numChannels() {
            switch (this) {
                case GRAYSCALE: {
                    return 1;
                }
                case COLOR: {
                    return 3;
                }
            }
            throw new IllegalArgumentException("Invalid FLAG");
        }
    }

    public static enum Interpolation {
        NEAREST,
        BILINEAR,
        AREA,
        BICUBIC;

    }
}

