/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.maven.plugin;

import aQute.bnd.maven.lib.executions.PluginExecutions;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="aQute.bnd.maven.plugin.BndPackagingLifecycleParticipant")
public class BndPackagingLifecycleParticipant
extends AbstractMavenLifecycleParticipant
implements LogEnabled {
    public static final String THIS_GROUP_ID = "biz.aQute.bnd";
    public static final String THIS_ARTIFACT_ID = "bnd-maven-plugin";
    public static final String MAVEN_JAR_PLUGIN_GROUP_ID = "org.apache.maven.plugins";
    public static final String MAVEN_JAR_PLUGIN_ARTIFACT_ID = "maven-jar-plugin";
    public static final String MAVEN_WAR_PLUGIN_GROUP_ID = "org.apache.maven.plugins";
    public static final String MAVEN_WAR_PLUGIN_ARTIFACT_ID = "maven-war-plugin";
    private Logger logger;

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        try {
            for (MavenProject project : session.getProjects()) {
                Plugin mavenWarPlugin;
                Model model = project.getModel();
                Plugin bndMavenPlugin = this.getBndMavenPlugin(model);
                if (bndMavenPlugin == null) continue;
                Plugin mavenJarPlugin = this.getMavenJarPlugin(model);
                if (mavenJarPlugin != null) {
                    this.processExecutions(bndMavenPlugin.getExecutions(), mavenJarPlugin, project);
                }
                if ((mavenWarPlugin = this.getMavenWarPlugin(model)) == null) continue;
                this.processExecutions(bndMavenPlugin.getExecutions(), mavenWarPlugin, project);
            }
        }
        catch (IllegalStateException e) {
            throw new MavenExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    protected Optional<PluginExecution> findMatchingMavenPackagingPluginExecution(List<PluginExecution> mavenPackagingPluginExecutions, String classifier) {
        return mavenPackagingPluginExecutions.stream().filter(execution -> PluginExecutions.matchesClassifier((PluginExecution)execution, (String)classifier)).findFirst();
    }

    protected Plugin getBndMavenPlugin(Model model) {
        Build build = model.getBuild();
        if (build != null) {
            return this.getBndMavenPluginFromContainer((PluginContainer)build);
        }
        return null;
    }

    protected Plugin getBndMavenPluginFromContainer(PluginContainer pluginContainer) {
        return this.getPluginByGAFromContainer(THIS_GROUP_ID, THIS_ARTIFACT_ID, pluginContainer);
    }

    protected Plugin getMavenJarPlugin(Model model) {
        Build build;
        if (Objects.equals(model.getPackaging(), "jar") && (build = model.getBuild()) != null) {
            return this.getMavenJarPluginFromContainer((PluginContainer)build);
        }
        return null;
    }

    protected Plugin getMavenJarPluginFromContainer(PluginContainer pluginContainer) {
        return this.getPluginByGAFromContainer("org.apache.maven.plugins", MAVEN_JAR_PLUGIN_ARTIFACT_ID, pluginContainer);
    }

    protected Plugin getMavenWarPlugin(Model model) {
        Build build;
        if (Objects.equals(model.getPackaging(), "war") && (build = model.getBuild()) != null) {
            return this.getMavenWarPluginFromContainer((PluginContainer)build);
        }
        return null;
    }

    protected Plugin getMavenWarPluginFromContainer(PluginContainer pluginContainer) {
        return this.getPluginByGAFromContainer("org.apache.maven.plugins", MAVEN_WAR_PLUGIN_ARTIFACT_ID, pluginContainer);
    }

    protected Plugin getPluginByGAFromContainer(String groupId, String artifactId, PluginContainer pluginContainer) {
        Plugin result = null;
        for (Plugin plugin : pluginContainer.getPlugins()) {
            if (!this.nullToEmpty(groupId).equals(this.nullToEmpty(plugin.getGroupId())) || !this.nullToEmpty(artifactId).equals(this.nullToEmpty(plugin.getArtifactId()))) continue;
            if (result != null) {
                throw new IllegalStateException("The build contains multiple versions of plugin " + groupId + ":" + artifactId);
            }
            result = plugin;
        }
        return result;
    }

    protected String nullToEmpty(String str) {
        return Optional.ofNullable(str).orElse("");
    }

    protected void processExecutions(List<PluginExecution> bndMavenPluginExecutions, Plugin mavenPackagingPlugin, MavenProject project) {
        bndMavenPluginExecutions.stream().filter(PluginExecutions::isPackagingGoal).forEach(bndMavenPluginExecution -> {
            String classifier = PluginExecutions.extractClassifier((PluginExecution)bndMavenPluginExecution);
            this.findMatchingMavenPackagingPluginExecution(mavenPackagingPlugin.getExecutions(), classifier).ifPresent(execution -> {
                List goals = execution.getGoals();
                boolean removed = goals.removeIf(goal -> {
                    if (PluginExecutions.isPackagingGoal((String)goal)) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("bnd-maven-plugin disabled " + mavenPackagingPlugin.getArtifactId() + ":" + goal + " (" + execution.getId() + ") @ " + project.getArtifactId());
                        }
                        return true;
                    }
                    return false;
                });
                if (removed && goals.isEmpty()) {
                    mavenPackagingPlugin.removeExecution(execution);
                }
            });
        });
    }
}

