/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.collection;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Opt;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.stream.StreamUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CollStreamUtil {
    public static <V, K> Map<K, V> toIdentityMap(Collection<V> collection, Function<V, K> key) {
        return CollStreamUtil.toIdentityMap(collection, key, false);
    }

    public static <V, K> Map<K, V> toIdentityMap(Collection<V> collection, Function<V, K> key, boolean isParallel) {
        if (CollUtil.isEmpty(collection)) {
            return Collections.emptyMap();
        }
        return CollStreamUtil.toMap(collection, v -> Opt.ofNullable(v).map(key).get(), Function.identity(), isParallel);
    }

    public static <E, K, V> Map<K, V> toMap(Collection<E> collection, Function<E, K> key, Function<E, V> value) {
        return CollStreamUtil.toMap(collection, key, value, false);
    }

    public static <E, K, V> Map<K, V> toMap(Collection<E> collection, Function<E, K> key, Function<E, V> value, boolean isParallel) {
        if (CollUtil.isEmpty(collection)) {
            return Collections.emptyMap();
        }
        return StreamUtil.of(collection, isParallel).collect(HashMap::new, (m, v) -> m.put(key.apply(v), value.apply(v)), HashMap::putAll);
    }

    public static <E, K> Map<K, List<E>> groupByKey(Collection<E> collection, Function<E, K> key) {
        return CollStreamUtil.groupByKey(collection, key, false);
    }

    public static <E, K> Map<K, List<E>> groupByKey(Collection<E> collection, Function<E, K> key, boolean isParallel) {
        if (CollUtil.isEmpty(collection)) {
            return Collections.emptyMap();
        }
        return StreamUtil.of(collection, isParallel).collect(Collectors.groupingBy(key, Collectors.toList()));
    }

    public static <E, K, U> Map<K, Map<U, List<E>>> groupBy2Key(Collection<E> collection, Function<E, K> key1, Function<E, U> key2) {
        return CollStreamUtil.groupBy2Key(collection, key1, key2, false);
    }

    public static <E, K, U> Map<K, Map<U, List<E>>> groupBy2Key(Collection<E> collection, Function<E, K> key1, Function<E, U> key2, boolean isParallel) {
        if (CollUtil.isEmpty(collection)) {
            return Collections.emptyMap();
        }
        return StreamUtil.of(collection, isParallel).collect(Collectors.groupingBy(key1, Collectors.groupingBy(key2, Collectors.toList())));
    }

    public static <E, T, U> Map<T, Map<U, E>> group2Map(Collection<E> collection, Function<E, T> key1, Function<E, U> key2) {
        return CollStreamUtil.group2Map(collection, key1, key2, false);
    }

    public static <E, T, U> Map<T, Map<U, E>> group2Map(Collection<E> collection, Function<E, T> key1, Function<E, U> key2, boolean isParallel) {
        if (CollUtil.isEmpty(collection) || key1 == null || key2 == null) {
            return Collections.emptyMap();
        }
        return StreamUtil.of(collection, isParallel).collect(Collectors.groupingBy(key1, Collectors.toMap(key2, Function.identity(), (l, r) -> l)));
    }

    public static <E, T> List<T> toList(Collection<E> collection, Function<E, T> function) {
        return CollStreamUtil.toList(collection, function, false);
    }

    public static <E, T> List<T> toList(Collection<E> collection, Function<E, T> function, boolean isParallel) {
        if (CollUtil.isEmpty(collection)) {
            return Collections.emptyList();
        }
        return StreamUtil.of(collection, isParallel).map(function).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <E, T> Set<T> toSet(Collection<E> collection, Function<E, T> function) {
        return CollStreamUtil.toSet(collection, function, false);
    }

    public static <E, T> Set<T> toSet(Collection<E> collection, Function<E, T> function, boolean isParallel) {
        if (CollUtil.isEmpty(collection)) {
            return Collections.emptySet();
        }
        return StreamUtil.of(collection, isParallel).map(function).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static <K, X, Y, V> Map<K, V> merge(Map<K, X> map1, Map<K, Y> map2, BiFunction<X, Y, V> merge) {
        if (MapUtil.isEmpty(map1) && MapUtil.isEmpty(map2)) {
            return Collections.emptyMap();
        }
        if (MapUtil.isEmpty(map1)) {
            map1 = Collections.emptyMap();
        } else if (MapUtil.isEmpty(map2)) {
            map2 = Collections.emptyMap();
        }
        HashSet<K> key = new HashSet<K>();
        key.addAll(map1.keySet());
        key.addAll(map2.keySet());
        HashMap map = MapUtil.newHashMap(key.size());
        for (Object t : key) {
            Object y;
            Object x = map1.get(t);
            V z = merge.apply(x, y = map2.get(t));
            if (z == null) continue;
            map.put(t, z);
        }
        return map;
    }
}

