/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ccr;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ccr.ForgetFollowerResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ForgetFollowerRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String followerCluster;
    @Nullable
    private final String followerIndex;
    @Nullable
    private final String followerIndexUuid;
    private final String index;
    @Nullable
    private final String leaderRemoteCluster;
    public static final JsonpDeserializer<ForgetFollowerRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ForgetFollowerRequest::setupForgetFollowerRequestDeserializer);
    public static final Endpoint<ForgetFollowerRequest, ForgetFollowerResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ForgetFollowerRequest, ForgetFollowerResponse>("es/ccr.forget_follower", request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_ccr");
            buf.append("/forget_follower");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, ForgetFollowerResponse._DESERIALIZER);

    private ForgetFollowerRequest(Builder builder) {
        this.followerCluster = builder.followerCluster;
        this.followerIndex = builder.followerIndex;
        this.followerIndexUuid = builder.followerIndexUuid;
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.leaderRemoteCluster = builder.leaderRemoteCluster;
    }

    public static ForgetFollowerRequest of(Function<Builder, ObjectBuilder<ForgetFollowerRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String followerCluster() {
        return this.followerCluster;
    }

    @Nullable
    public final String followerIndex() {
        return this.followerIndex;
    }

    @Nullable
    public final String followerIndexUuid() {
        return this.followerIndexUuid;
    }

    public final String index() {
        return this.index;
    }

    @Nullable
    public final String leaderRemoteCluster() {
        return this.leaderRemoteCluster;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.followerCluster != null) {
            generator.writeKey("follower_cluster");
            generator.write(this.followerCluster);
        }
        if (this.followerIndex != null) {
            generator.writeKey("follower_index");
            generator.write(this.followerIndex);
        }
        if (this.followerIndexUuid != null) {
            generator.writeKey("follower_index_uuid");
            generator.write(this.followerIndexUuid);
        }
        if (this.leaderRemoteCluster != null) {
            generator.writeKey("leader_remote_cluster");
            generator.write(this.leaderRemoteCluster);
        }
    }

    protected static void setupForgetFollowerRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::followerCluster, JsonpDeserializer.stringDeserializer(), "follower_cluster");
        op.add(Builder::followerIndex, JsonpDeserializer.stringDeserializer(), "follower_index");
        op.add(Builder::followerIndexUuid, JsonpDeserializer.stringDeserializer(), "follower_index_uuid");
        op.add(Builder::leaderRemoteCluster, JsonpDeserializer.stringDeserializer(), "leader_remote_cluster");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ForgetFollowerRequest> {
        @Nullable
        private String followerCluster;
        @Nullable
        private String followerIndex;
        @Nullable
        private String followerIndexUuid;
        private String index;
        @Nullable
        private String leaderRemoteCluster;

        public final Builder followerCluster(@Nullable String value) {
            this.followerCluster = value;
            return this;
        }

        public final Builder followerIndex(@Nullable String value) {
            this.followerIndex = value;
            return this;
        }

        public final Builder followerIndexUuid(@Nullable String value) {
            this.followerIndexUuid = value;
            return this;
        }

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder leaderRemoteCluster(@Nullable String value) {
            this.leaderRemoteCluster = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ForgetFollowerRequest build() {
            this._checkSingleUse();
            return new ForgetFollowerRequest(this);
        }
    }
}

