/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.Context;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.NamedDeserializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CompletionSuggestOption<TDocument>
implements JsonpSerializable {
    @Nullable
    private final Boolean collateMatch;
    private final Map<String, List<Context>> contexts;
    private final Map<String, JsonData> fields;
    private final String id;
    private final String index;
    @Nullable
    private final String routing;
    @Nullable
    private final Double score;
    @Nullable
    private final TDocument source;
    private final String text;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;
    public static final JsonpDeserializer<CompletionSuggestOption<Object>> _DESERIALIZER = JsonpDeserializer.lazy(() -> CompletionSuggestOption.createCompletionSuggestOptionDeserializer(new NamedDeserializer("co.elastic.clients:Deserializer:_global.search._types.TDocument")));

    private CompletionSuggestOption(Builder<TDocument> builder) {
        this.collateMatch = ((Builder)builder).collateMatch;
        this.contexts = ApiTypeHelper.unmodifiable(((Builder)builder).contexts);
        this.fields = ApiTypeHelper.unmodifiable(((Builder)builder).fields);
        this.id = ApiTypeHelper.requireNonNull(((Builder)builder).id, this, "id");
        this.index = ApiTypeHelper.requireNonNull(((Builder)builder).index, this, "index");
        this.routing = ((Builder)builder).routing;
        this.score = ((Builder)builder).score;
        this.source = ((Builder)builder).source;
        this.text = ApiTypeHelper.requireNonNull(((Builder)builder).text, this, "text");
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
    }

    public static <TDocument> CompletionSuggestOption<TDocument> of(Function<Builder<TDocument>, ObjectBuilder<CompletionSuggestOption<TDocument>>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean collateMatch() {
        return this.collateMatch;
    }

    public final Map<String, List<Context>> contexts() {
        return this.contexts;
    }

    public final Map<String, JsonData> fields() {
        return this.fields;
    }

    public final String id() {
        return this.id;
    }

    public final String index() {
        return this.index;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    @Nullable
    public final Double score() {
        return this.score;
    }

    @Nullable
    public final TDocument source() {
        return this.source;
    }

    public final String text() {
        return this.text;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.collateMatch != null) {
            generator.writeKey("collate_match");
            generator.write(this.collateMatch.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.contexts)) {
            generator.writeKey("contexts");
            generator.writeStartObject();
            for (Map.Entry<String, List<Context>> entry : this.contexts.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.writeStartArray();
                if (entry.getValue() != null) {
                    for (Context item1 : entry.getValue()) {
                        item1.serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.fields.entrySet()) {
                generator.writeKey(entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("_id");
        generator.write(this.id);
        generator.writeKey("_index");
        generator.write(this.index);
        if (this.routing != null) {
            generator.writeKey("_routing");
            generator.write(this.routing);
        }
        if (this.score != null) {
            generator.writeKey("_score");
            generator.write(this.score.doubleValue());
        }
        if (this.source != null) {
            generator.writeKey("_source");
            JsonpUtils.serialize(this.source, generator, this.tDocumentSerializer, mapper);
        }
        generator.writeKey("text");
        generator.write(this.text);
    }

    public static <TDocument> JsonpDeserializer<CompletionSuggestOption<TDocument>> createCompletionSuggestOptionDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> CompletionSuggestOption.setupCompletionSuggestOptionDeserializer(op, tDocumentDeserializer));
    }

    protected static <TDocument> void setupCompletionSuggestOptionDeserializer(ObjectDeserializer<Builder<TDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        op.add(Builder::collateMatch, JsonpDeserializer.booleanDeserializer(), "collate_match");
        op.add(Builder::contexts, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(Context._DESERIALIZER)), "contexts");
        op.add(Builder::fields, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "fields");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "_index");
        op.add(Builder::routing, JsonpDeserializer.stringDeserializer(), "_routing");
        op.add(Builder::score, JsonpDeserializer.doubleDeserializer(), "_score");
        op.add(Builder::source, tDocumentDeserializer, "_source");
        op.add(Builder::text, JsonpDeserializer.stringDeserializer(), "text");
    }

    public static class Builder<TDocument>
    extends WithJsonObjectBuilderBase<Builder<TDocument>>
    implements ObjectBuilder<CompletionSuggestOption<TDocument>> {
        @Nullable
        private Boolean collateMatch;
        @Nullable
        private Map<String, List<Context>> contexts;
        @Nullable
        private Map<String, JsonData> fields;
        private String id;
        private String index;
        @Nullable
        private String routing;
        @Nullable
        private Double score;
        @Nullable
        private TDocument source;
        private String text;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public final Builder<TDocument> collateMatch(@Nullable Boolean value) {
            this.collateMatch = value;
            return this;
        }

        public final Builder<TDocument> contexts(Map<String, List<Context>> map) {
            this.contexts = Builder._mapPutAll(this.contexts, map);
            return this;
        }

        public final Builder<TDocument> contexts(String key, List<Context> value) {
            this.contexts = Builder._mapPut(this.contexts, key, value);
            return this;
        }

        public final Builder<TDocument> fields(Map<String, JsonData> map) {
            this.fields = Builder._mapPutAll(this.fields, map);
            return this;
        }

        public final Builder<TDocument> fields(String key, JsonData value) {
            this.fields = Builder._mapPut(this.fields, key, value);
            return this;
        }

        public final Builder<TDocument> id(String value) {
            this.id = value;
            return this;
        }

        public final Builder<TDocument> index(String value) {
            this.index = value;
            return this;
        }

        public final Builder<TDocument> routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public final Builder<TDocument> score(@Nullable Double value) {
            this.score = value;
            return this;
        }

        public final Builder<TDocument> source(@Nullable TDocument value) {
            this.source = value;
            return this;
        }

        public final Builder<TDocument> text(String value) {
            this.text = value;
            return this;
        }

        public final Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        protected Builder<TDocument> self() {
            return this;
        }

        @Override
        public CompletionSuggestOption<TDocument> build() {
            this._checkSingleUse();
            return new CompletionSuggestOption(this);
        }
    }
}

