/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.shard_stores;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ShardStoreException
implements JsonpSerializable {
    private final String reason;
    private final String type;
    public static final JsonpDeserializer<ShardStoreException> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardStoreException::setupShardStoreExceptionDeserializer);

    private ShardStoreException(Builder builder) {
        this.reason = ApiTypeHelper.requireNonNull(builder.reason, this, "reason");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
    }

    public static ShardStoreException of(Function<Builder, ObjectBuilder<ShardStoreException>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String reason() {
        return this.reason;
    }

    public final String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("reason");
        generator.write(this.reason);
        generator.writeKey("type");
        generator.write(this.type);
    }

    protected static void setupShardStoreExceptionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ShardStoreException> {
        private String reason;
        private String type;

        public final Builder reason(String value) {
            this.reason = value;
            return this;
        }

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ShardStoreException build() {
            this._checkSingleUse();
            return new ShardStoreException(this);
        }
    }
}

