/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.put_trained_model;

import co.elastic.clients.elasticsearch.ml.put_trained_model.Preprocessor;
import co.elastic.clients.elasticsearch.ml.put_trained_model.PreprocessorVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class OneHotEncodingPreprocessor
implements PreprocessorVariant,
JsonpSerializable {
    private final String field;
    private final Map<String, String> hotMap;
    public static final JsonpDeserializer<OneHotEncodingPreprocessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, OneHotEncodingPreprocessor::setupOneHotEncodingPreprocessorDeserializer);

    private OneHotEncodingPreprocessor(Builder builder) {
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.hotMap = ApiTypeHelper.unmodifiableRequired(builder.hotMap, (Object)this, "hotMap");
    }

    public static OneHotEncodingPreprocessor of(Function<Builder, ObjectBuilder<OneHotEncodingPreprocessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Preprocessor.Kind _preprocessorKind() {
        return Preprocessor.Kind.OneHotEncoding;
    }

    public final String field() {
        return this.field;
    }

    public final Map<String, String> hotMap() {
        return this.hotMap;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field");
        generator.write(this.field);
        if (ApiTypeHelper.isDefined(this.hotMap)) {
            generator.writeKey("hot_map");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.hotMap.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
    }

    protected static void setupOneHotEncodingPreprocessorDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::hotMap, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "hot_map");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<OneHotEncodingPreprocessor> {
        private String field;
        private Map<String, String> hotMap;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder hotMap(Map<String, String> map) {
            this.hotMap = Builder._mapPutAll(this.hotMap, map);
            return this;
        }

        public final Builder hotMap(String key, String value) {
            this.hotMap = Builder._mapPut(this.hotMap, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public OneHotEncodingPreprocessor build() {
            this._checkSingleUse();
            return new OneHotEncodingPreprocessor(this);
        }
    }
}

