/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch.snapshot.FileCountSnapshotStats;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class SnapshotStats
implements JsonpSerializable {
    private final FileCountSnapshotStats incremental;
    private final long startTimeInMillis;
    private final long timeInMillis;
    private final FileCountSnapshotStats total;
    public static final JsonpDeserializer<SnapshotStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SnapshotStats::setupSnapshotStatsDeserializer);

    private SnapshotStats(Builder builder) {
        this.incremental = ApiTypeHelper.requireNonNull(builder.incremental, this, "incremental");
        this.startTimeInMillis = ApiTypeHelper.requireNonNull(builder.startTimeInMillis, this, "startTimeInMillis");
        this.timeInMillis = ApiTypeHelper.requireNonNull(builder.timeInMillis, this, "timeInMillis");
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
    }

    public static SnapshotStats of(Function<Builder, ObjectBuilder<SnapshotStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final FileCountSnapshotStats incremental() {
        return this.incremental;
    }

    public final long startTimeInMillis() {
        return this.startTimeInMillis;
    }

    public final long timeInMillis() {
        return this.timeInMillis;
    }

    public final FileCountSnapshotStats total() {
        return this.total;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("incremental");
        this.incremental.serialize(generator, mapper);
        generator.writeKey("start_time_in_millis");
        generator.write(this.startTimeInMillis);
        generator.writeKey("time_in_millis");
        generator.write(this.timeInMillis);
        generator.writeKey("total");
        this.total.serialize(generator, mapper);
    }

    protected static void setupSnapshotStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::incremental, FileCountSnapshotStats._DESERIALIZER, "incremental");
        op.add(Builder::startTimeInMillis, JsonpDeserializer.longDeserializer(), "start_time_in_millis");
        op.add(Builder::timeInMillis, JsonpDeserializer.longDeserializer(), "time_in_millis");
        op.add(Builder::total, FileCountSnapshotStats._DESERIALIZER, "total");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SnapshotStats> {
        private FileCountSnapshotStats incremental;
        private Long startTimeInMillis;
        private Long timeInMillis;
        private FileCountSnapshotStats total;

        public final Builder incremental(FileCountSnapshotStats value) {
            this.incremental = value;
            return this;
        }

        public final Builder incremental(Function<FileCountSnapshotStats.Builder, ObjectBuilder<FileCountSnapshotStats>> fn) {
            return this.incremental(fn.apply(new FileCountSnapshotStats.Builder()).build());
        }

        public final Builder startTimeInMillis(long value) {
            this.startTimeInMillis = value;
            return this;
        }

        public final Builder timeInMillis(long value) {
            this.timeInMillis = value;
            return this;
        }

        public final Builder total(FileCountSnapshotStats value) {
            this.total = value;
            return this;
        }

        public final Builder total(Function<FileCountSnapshotStats.Builder, ObjectBuilder<FileCountSnapshotStats>> fn) {
            return this.total(fn.apply(new FileCountSnapshotStats.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SnapshotStats build() {
            this._checkSingleUse();
            return new SnapshotStats(this);
        }
    }
}

