/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.inference.GetModelResponse;
import co.elastic.clients.elasticsearch.inference.TaskType;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class GetModelRequest
extends RequestBase {
    private final String inferenceId;
    @Nullable
    private final TaskType taskType;
    public static final Endpoint<GetModelRequest, GetModelResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetModelRequest, GetModelResponse>("es/inference.get_model", request -> "GET", request -> {
        boolean _inferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if (request.taskType() != null) {
            propsSet |= 2;
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.inferenceId, buf);
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskType.jsonValue(), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.inferenceId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _inferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if (request.taskType() != null) {
            propsSet |= 2;
        }
        if (propsSet == 1) {
            params.put("inferenceId", request.inferenceId);
        }
        if (propsSet == 3) {
            params.put("taskType", request.taskType.jsonValue());
            params.put("inferenceId", request.inferenceId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, GetModelResponse._DESERIALIZER);

    private GetModelRequest(Builder builder) {
        this.inferenceId = ApiTypeHelper.requireNonNull(builder.inferenceId, this, "inferenceId");
        this.taskType = builder.taskType;
    }

    public static GetModelRequest of(Function<Builder, ObjectBuilder<GetModelRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String inferenceId() {
        return this.inferenceId;
    }

    @Nullable
    public final TaskType taskType() {
        return this.taskType;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GetModelRequest> {
        private String inferenceId;
        @Nullable
        private TaskType taskType;

        public final Builder inferenceId(String value) {
            this.inferenceId = value;
            return this;
        }

        public final Builder taskType(@Nullable TaskType value) {
            this.taskType = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetModelRequest build() {
            this._checkSingleUse();
            return new GetModelRequest(this);
        }
    }
}

