/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.mcp.gateway.core;

import com.alibaba.cloud.ai.mcp.gateway.core.McpGatewayProperties;
import com.alibaba.cloud.ai.mcp.gateway.core.McpGatewayToolCallbackProvider;
import com.alibaba.cloud.ai.mcp.gateway.core.McpGatewayToolsInitializer;
import com.alibaba.cloud.ai.mcp.gateway.core.utils.SpringBeanUtils;
import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.mcp.McpToolUtils;
import org.springframework.ai.mcp.server.autoconfigure.McpServerAutoConfiguration;
import org.springframework.ai.mcp.server.autoconfigure.McpServerProperties;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.lang.NonNull;
import org.springframework.util.MimeType;

@AutoConfiguration(after={McpServerAutoConfiguration.class})
@EnableConfigurationProperties(value={McpServerProperties.class, McpGatewayProperties.class})
@ConditionalOnClass(value={McpServer.class, McpServerTransportProvider.class})
@ConditionalOnProperty(name={"spring.ai.alibaba.mcp.gateway.enabled"}, havingValue="true", matchIfMissing=false)
public class McpGatewayServerAutoConfiguration
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(McpGatewayServerAutoConfiguration.class);

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        SpringBeanUtils.getInstance().setApplicationContext(applicationContext);
    }

    @Bean
    public ToolCallbackProvider callbackProvider(McpGatewayToolsInitializer mcpGatewayToolsInitializer) {
        return McpGatewayToolCallbackProvider.builder().toolCallbacks(mcpGatewayToolsInitializer.initializeTools()).build();
    }

    @ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"type"}, havingValue="SYNC", matchIfMissing=true)
    public List<McpServerFeatures.SyncToolSpecification> gatewaySyncTools(ObjectProvider<List<McpServerFeatures.SyncToolSpecification>> tools, List<ToolCallbackProvider> toolCallbackProvider, McpServerProperties serverProperties) {
        ArrayList<McpServerFeatures.SyncToolSpecification> toolSpecifications = new ArrayList<McpServerFeatures.SyncToolSpecification>(tools.stream().flatMap(Collection::stream).toList());
        List<ToolCallback> providerToolCallbacks = toolCallbackProvider.stream().map(pr -> List.of(pr.getToolCallbacks())).flatMap(Collection::stream).filter(Objects::nonNull).toList();
        toolSpecifications.addAll(this.toSyncToolSpecifications(providerToolCallbacks, serverProperties));
        return toolSpecifications;
    }

    private List<McpServerFeatures.SyncToolSpecification> toSyncToolSpecifications(List<ToolCallback> tools, McpServerProperties serverProperties) {
        return tools.stream().collect(Collectors.toMap(tool -> tool.getToolDefinition().name(), tool -> tool, (existing, replacement) -> existing)).values().stream().map(tool -> {
            String toolName = tool.getToolDefinition().name();
            MimeType mimeType = serverProperties.getToolResponseMimeType().containsKey(toolName) ? MimeType.valueOf((String)((String)serverProperties.getToolResponseMimeType().get(toolName))) : null;
            return McpToolUtils.toSyncToolSpecification((ToolCallback)tool, mimeType);
        }).toList();
    }

    @ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"type"}, havingValue="ASYNC")
    public List<McpServerFeatures.AsyncToolSpecification> gatewayAsyncTools(ObjectProvider<List<McpServerFeatures.AsyncToolSpecification>> tools, List<ToolCallbackProvider> toolCallbackProvider, McpServerProperties serverProperties) {
        ArrayList<McpServerFeatures.AsyncToolSpecification> toolSpecifications = new ArrayList<McpServerFeatures.AsyncToolSpecification>(tools.stream().flatMap(Collection::stream).toList());
        List<ToolCallback> providerToolCallbacks = toolCallbackProvider.stream().map(pr -> List.of(pr.getToolCallbacks())).flatMap(Collection::stream).filter(Objects::nonNull).toList();
        toolSpecifications.addAll(this.toAsyncToolSpecification(providerToolCallbacks, serverProperties));
        return toolSpecifications;
    }

    private List<McpServerFeatures.AsyncToolSpecification> toAsyncToolSpecification(List<ToolCallback> tools, McpServerProperties serverProperties) {
        return tools.stream().collect(Collectors.toMap(tool -> tool.getToolDefinition().name(), tool -> tool, (existing, replacement) -> existing)).values().stream().map(tool -> {
            String toolName = tool.getToolDefinition().name();
            MimeType mimeType = serverProperties.getToolResponseMimeType().containsKey(toolName) ? MimeType.valueOf((String)((String)serverProperties.getToolResponseMimeType().get(toolName))) : null;
            return McpToolUtils.toAsyncToolSpecification((ToolCallback)tool, mimeType);
        }).toList();
    }
}

