/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.mcp.gateway.nacos;

import com.alibaba.cloud.ai.autoconfigure.mcp.gateway.core.McpGatewayServerAutoConfiguration;
import com.alibaba.cloud.ai.mcp.gateway.core.McpGatewayToolManager;
import com.alibaba.cloud.ai.mcp.gateway.core.McpGatewayToolsInitializer;
import com.alibaba.cloud.ai.mcp.gateway.nacos.properties.NacosMcpGatewayProperties;
import com.alibaba.cloud.ai.mcp.gateway.nacos.provider.NacosMcpAsyncGatewayToolsProvider;
import com.alibaba.cloud.ai.mcp.gateway.nacos.provider.NacosMcpSyncGatewayToolsProvider;
import com.alibaba.cloud.ai.mcp.gateway.nacos.tools.NacosMcpGatewayToolsInitializer;
import com.alibaba.cloud.ai.mcp.gateway.nacos.watcher.NacosMcpGatewayToolsWatcher;
import com.alibaba.cloud.ai.mcp.nacos.NacosMcpProperties;
import com.alibaba.cloud.ai.mcp.nacos.service.NacosMcpOperationService;
import com.alibaba.nacos.api.exception.NacosException;
import io.modelcontextprotocol.server.McpAsyncServer;
import io.modelcontextprotocol.server.McpSyncServer;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.mcp.server.autoconfigure.McpServerProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={NacosMcpGatewayProperties.class, NacosMcpProperties.class, McpServerProperties.class})
@AutoConfiguration(after={McpGatewayServerAutoConfiguration.class})
@ConditionalOnProperty(prefix="spring.ai.alibaba.mcp.gateway", name={"registry"}, havingValue="nacos", matchIfMissing=true)
public class NacosMcpGatewayAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(NacosMcpGatewayAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={NacosMcpOperationService.class})
    public NacosMcpOperationService nacosMcpOperationService(NacosMcpProperties nacosMcpProperties) {
        Properties nacosProperties = nacosMcpProperties.getNacosProperties();
        try {
            return new NacosMcpOperationService(nacosProperties);
        }
        catch (NacosException e) {
            throw new RuntimeException(e);
        }
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.alibaba.mcp.gateway", name={"enabled"}, havingValue="true", matchIfMissing=false)
    public McpGatewayToolsInitializer nacosMcpGatewayToolsInitializer(NacosMcpOperationService nacosMcpOperationService, NacosMcpGatewayProperties nacosMcpGatewayProperties) {
        return new NacosMcpGatewayToolsInitializer(nacosMcpOperationService, nacosMcpGatewayProperties);
    }

    @Bean(destroyMethod="stop")
    @ConditionalOnProperty(prefix="spring.ai.alibaba.mcp.gateway", name={"enabled"}, havingValue="true", matchIfMissing=false)
    public NacosMcpGatewayToolsWatcher nacosInstanceWatcher(McpGatewayToolManager mcpGatewayToolManager, NacosMcpOperationService nacosMcpOperationService, NacosMcpGatewayProperties nacosMcpGatewayProperties) {
        return new NacosMcpGatewayToolsWatcher(mcpGatewayToolManager, nacosMcpOperationService, nacosMcpGatewayProperties);
    }

    @Bean
    @ConditionalOnBean(value={McpAsyncServer.class})
    @ConditionalOnMissingBean(value={McpGatewayToolManager.class})
    @ConditionalOnProperty(prefix="spring.ai.alibaba.mcp.gateway", name={"enabled"}, havingValue="true", matchIfMissing=false)
    public McpGatewayToolManager nacosMcpGatewayAsyncToolsProvider(McpAsyncServer mcpAsyncServer) {
        return new NacosMcpAsyncGatewayToolsProvider(mcpAsyncServer);
    }

    @Bean
    @ConditionalOnBean(value={McpSyncServer.class})
    @ConditionalOnMissingBean(value={McpGatewayToolManager.class})
    @ConditionalOnProperty(prefix="spring.ai.alibaba.mcp.gateway", name={"enabled"}, havingValue="true", matchIfMissing=false)
    public McpGatewayToolManager nacosMcpGatewaySyncToolsProvider(McpSyncServer mcpSyncServer) {
        return new NacosMcpSyncGatewayToolsProvider(mcpSyncServer);
    }
}

