/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.mcp.router;

import com.alibaba.cloud.ai.autoconfigure.mcp.router.McpServiceDiscoveryAutoConfiguration;
import com.alibaba.cloud.ai.mcp.router.config.DbMcpProperties;
import com.alibaba.cloud.ai.mcp.router.config.McpRouterProperties;
import com.alibaba.cloud.ai.mcp.router.core.discovery.DbMcpServiceDiscovery;
import com.alibaba.cloud.ai.mcp.router.core.discovery.McpServiceDiscovery;
import com.alibaba.cloud.ai.mcp.router.core.discovery.McpServiceDiscoveryFactory;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.mcp.server.autoconfigure.McpServerProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@AutoConfigureAfter(value={McpServiceDiscoveryAutoConfiguration.class})
@EnableConfigurationProperties(value={McpRouterProperties.class, DbMcpProperties.class, McpServerProperties.class})
@ConditionalOnProperty(prefix="spring.ai.alibaba.mcp.router", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class DbMcpRouterAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DbMcpRouterAutoConfiguration.class);

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.alibaba.mcp.router.database", name={"enabled"}, havingValue="true")
    public DbMcpServiceDiscoveryRegistrar dbMcpServiceDiscoveryRegistrar(McpServiceDiscoveryFactory discoveryFactory, DbMcpProperties dbMcpProperties) {
        log.info("Creating database MCP service discovery registrar with properties: {}", (Object)dbMcpProperties);
        return new DbMcpServiceDiscoveryRegistrar(discoveryFactory, dbMcpProperties);
    }

    public static class DbMcpServiceDiscoveryRegistrar {
        private final McpServiceDiscoveryFactory discoveryFactory;
        private final DbMcpProperties dbMcpProperties;

        public DbMcpServiceDiscoveryRegistrar(McpServiceDiscoveryFactory discoveryFactory, DbMcpProperties dbMcpProperties) {
            this.discoveryFactory = discoveryFactory;
            this.dbMcpProperties = dbMcpProperties;
            log.info("Database MCP service discovery registrar constructor called with properties: {}", (Object)dbMcpProperties);
        }

        @PostConstruct
        public void init() {
            log.info("Database MCP service discovery registrar initialized with properties: {}", (Object)this.dbMcpProperties);
            log.info("Registering DB MCP service discovery with configuration: {}", (Object)this.dbMcpProperties);
            DbMcpServiceDiscovery dbDiscovery = new DbMcpServiceDiscovery(this.dbMcpProperties);
            this.discoveryFactory.registerDiscovery("database", (McpServiceDiscovery)dbDiscovery);
        }
    }
}

