/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.mcp.router;

import com.alibaba.cloud.ai.autoconfigure.mcp.router.McpServiceDiscoveryAutoConfiguration;
import com.alibaba.cloud.ai.mcp.router.config.McpRouterProperties;
import com.alibaba.cloud.ai.mcp.router.core.discovery.FileConfigMcpServiceDiscovery;
import com.alibaba.cloud.ai.mcp.router.core.discovery.McpServiceDiscovery;
import com.alibaba.cloud.ai.mcp.router.core.discovery.McpServiceDiscoveryFactory;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.mcp.server.autoconfigure.McpServerProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@AutoConfigureAfter(value={McpServiceDiscoveryAutoConfiguration.class})
@EnableConfigurationProperties(value={McpRouterProperties.class, McpServerProperties.class})
@ConditionalOnProperty(prefix="spring.ai.alibaba.mcp.router", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class FileMcpRouterAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(FileMcpRouterAutoConfiguration.class);

    @Bean
    public FileMcpServiceDiscoveryRegistrar fileMcpServiceDiscoveryRegistrar(McpServiceDiscoveryFactory discoveryFactory, McpRouterProperties properties) {
        log.info("Creating file MCP service discovery registrar with properties: {}", (Object)properties);
        return new FileMcpServiceDiscoveryRegistrar(discoveryFactory, properties);
    }

    public static class FileMcpServiceDiscoveryRegistrar {
        private final McpServiceDiscoveryFactory discoveryFactory;
        private final McpRouterProperties properties;

        public FileMcpServiceDiscoveryRegistrar(McpServiceDiscoveryFactory discoveryFactory, McpRouterProperties properties) {
            this.discoveryFactory = discoveryFactory;
            this.properties = properties;
            log.info("File MCP service discovery registrar constructor called with properties: {}", (Object)properties);
        }

        @PostConstruct
        public void init() {
            log.info("File MCP service discovery registrar initialized with properties: {}", (Object)this.properties);
            log.info("Registering file config MCP service discovery with {} services", (Object)(this.properties.getServices() != null ? this.properties.getServices().size() : 0));
            FileConfigMcpServiceDiscovery fileDiscovery = new FileConfigMcpServiceDiscovery(this.properties);
            this.discoveryFactory.registerDiscovery("file", (McpServiceDiscovery)fileDiscovery);
        }
    }
}

