/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.mcp.router;

import com.alibaba.cloud.ai.mcp.router.config.McpRouterProperties;
import com.alibaba.cloud.ai.mcp.router.core.discovery.CompositeMcpServiceDiscovery;
import com.alibaba.cloud.ai.mcp.router.core.discovery.McpServiceDiscovery;
import com.alibaba.cloud.ai.mcp.router.core.discovery.McpServiceDiscoveryFactory;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

@AutoConfiguration
@EnableConfigurationProperties(value={McpRouterProperties.class})
@ConditionalOnProperty(prefix="spring.ai.alibaba.mcp.router", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class McpServiceDiscoveryAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(McpServiceDiscoveryAutoConfiguration.class);

    @Bean
    public McpServiceDiscoveryFactory mcpServiceDiscoveryFactory() {
        log.info("Creating MCP service discovery factory");
        return new McpServiceDiscoveryFactory();
    }

    @Bean
    @Primary
    public McpServiceDiscovery compositeMcpServiceDiscovery(McpServiceDiscoveryFactory discoveryFactory, McpRouterProperties properties) {
        List<String> searchOrder = this.getSearchOrder(properties);
        log.info("Creating composite MCP service discovery with search order: {}", searchOrder);
        return new CompositeMcpServiceDiscovery(discoveryFactory, searchOrder);
    }

    private List<String> getSearchOrder(McpRouterProperties properties) {
        if (properties.getDiscoveryOrder() != null && !properties.getDiscoveryOrder().isEmpty()) {
            return properties.getDiscoveryOrder();
        }
        return List.of("nacos");
    }
}

