/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.gateway.core;

import com.alibaba.cloud.ai.mcp.gateway.core.McpGatewayToolManager;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMcpGatewayToolsWatcher {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractMcpGatewayToolsWatcher.class);
    protected static final long DEFAULT_POLLING_INTERVAL = 30L;
    protected final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    protected final McpGatewayToolManager toolManager;

    public AbstractMcpGatewayToolsWatcher(McpGatewayToolManager toolManager) {
        if (toolManager == null) {
            throw new IllegalArgumentException("McpGatewayToolManager cannot be null");
        }
        this.toolManager = toolManager;
        this.startScheduledPolling();
    }

    protected void startScheduledPolling() {
        long pollingInterval = this.getPollingInterval();
        this.scheduler.scheduleAtFixedRate(this::watch, pollingInterval, pollingInterval, TimeUnit.SECONDS);
        logger.info("Started scheduled service polling with interval: {} seconds", (Object)pollingInterval);
    }

    public void stop() {
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            this.scheduler.shutdown();
            try {
                if (!this.scheduler.awaitTermination(60L, TimeUnit.SECONDS)) {
                    this.scheduler.shutdownNow();
                    if (!this.scheduler.awaitTermination(60L, TimeUnit.SECONDS)) {
                        logger.error("Scheduler did not terminate");
                    }
                }
            }
            catch (InterruptedException e) {
                this.scheduler.shutdownNow();
                Thread.currentThread().interrupt();
                logger.error("Interrupted while waiting for scheduler to terminate", (Throwable)e);
            }
        }
        logger.info("Stopped scheduled service polling and cleared cache");
    }

    protected void watch() {
        try {
            this.handleChange();
        }
        catch (Exception e) {
            logger.error("Error occurred during service watching", (Throwable)e);
        }
    }

    protected abstract void handleChange();

    protected long getPollingInterval() {
        return 30L;
    }
}

