/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.gateway.core.jsontemplate;

import com.alibaba.cloud.ai.mcp.gateway.core.jsontemplate.RequestTemplateInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriBuilder;

public class RequestTemplateParser {
    public static final Pattern PATH_VARIABLES_PATTERN = Pattern.compile("(?<!\\{)\\{([^}]+)\\}(?!\\})");

    public static RequestTemplateInfo parseRequestTemplate(JsonNode requestTemplate, JsonNode argsPosition) {
        int optionCount;
        String url = requestTemplate.path("url").asText();
        String method = requestTemplate.path("method").asText();
        boolean argsToUrlParam = requestTemplate.path("argsToUrlParam").asBoolean(false);
        boolean argsToJsonBody = requestTemplate.path("argsToJsonBody").asBoolean(false);
        boolean argsToFormBody = requestTemplate.path("argsToFormBody").asBoolean(false);
        JsonNode headers = requestTemplate.path("headers");
        JsonNode body = requestTemplate.path("body");
        if (body.isMissingNode() && !argsToJsonBody && !argsToFormBody) {
            argsToUrlParam = true;
        }
        if ((optionCount = (argsToUrlParam ? 1 : 0) + (argsToJsonBody ? 1 : 0) + (argsToFormBody ? 1 : 0) + (body.isMissingNode() ? 0 : 1)) > 1) {
            throw new IllegalArgumentException("Only one of urlToParam, argsToJsonBody, argsToFormBody, or argsToUrlParam should be specified");
        }
        return new RequestTemplateInfo(url, method, argsToUrlParam, argsToJsonBody, argsToFormBody, headers, body, argsPosition, requestTemplate);
    }

    public static URI buildUri(UriBuilder builder, String processedUrl, RequestTemplateInfo info, Map<String, Object> args) {
        if (processedUrl.contains("?")) {
            String[] urlParts = processedUrl.split("\\?", 2);
            String path = urlParts[0];
            String existingQuery = urlParts.length > 1 ? urlParts[1] : "";
            builder.path(path);
            if (!existingQuery.isEmpty()) {
                String[] queryPairs;
                for (String pair : queryPairs = existingQuery.split("&")) {
                    if (pair.isEmpty()) continue;
                    String[] stringArray = pair.split("=", 2);
                    if (stringArray.length == 2) {
                        builder.queryParam(stringArray[0], new Object[]{stringArray[1]});
                        continue;
                    }
                    if (stringArray.length != 1) continue;
                    builder.queryParam(stringArray[0], new Object[]{""});
                }
            }
        } else {
            builder.path(processedUrl);
        }
        for (Map.Entry<String, Object> entry : args.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            boolean addToQuery = info.argsToUrlParam;
            if (info.argsPosition != null && info.argsPosition.has(key)) {
                String position = info.argsPosition.path(key).asText();
                addToQuery = "query".equals(position);
            }
            if (!addToQuery || value == null) continue;
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                for (Object e : collection) {
                    builder.queryParam(key, new Object[]{e});
                }
                continue;
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                for (Map.Entry entry2 : map.entrySet()) {
                    if (entry2.getKey() == null || entry2.getValue() == null) continue;
                    builder.queryParam(entry2.getKey().toString(), new Object[]{entry2.getValue()});
                }
                continue;
            }
            builder.queryParam(key, new Object[]{value});
        }
        return builder.build(new Object[0]);
    }

    private static void handleCookies(WebClient.RequestBodySpec requestSpec, MultiValueMap<String, String> headers, RequestTemplateInfo info, Map<String, Object> args) {
        StringBuilder cookieBuilder = new StringBuilder();
        for (Map.Entry<String, Object> entry : args.entrySet()) {
            String position;
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null || info.argsPosition == null || !info.argsPosition.has(key) || !"cookie".equals(position = info.argsPosition.path(key).asText())) continue;
            if (!cookieBuilder.isEmpty()) {
                cookieBuilder.append("; ");
            }
            cookieBuilder.append(key).append("=").append(value.toString());
        }
        if (!cookieBuilder.isEmpty()) {
            String cookieHeader = cookieBuilder.toString();
            requestSpec.header("Cookie", new String[]{cookieHeader});
            headers.add((Object)"Cookie", (Object)cookieHeader);
        }
    }

    public static MultiValueMap<String, String> addHeaders(WebClient.RequestBodySpec requestSpec, RequestTemplateInfo info, Map<String, Object> args, BiFunction<String, Map<String, Object>, String> templateProcessor) {
        String key;
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        JsonNode headersNode = info.headers;
        if (headersNode != null && headersNode.isArray()) {
            for (JsonNode header : headersNode) {
                key = header.path("key").asText();
                String valueTemplate = header.path("value").asText();
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("args", args);
                params.put("extendedData", "");
                String value = templateProcessor.apply(valueTemplate, params);
                requestSpec.header(key, new String[]{value});
                headers.add((Object)key, (Object)value);
            }
        }
        RequestTemplateParser.handleCookies(requestSpec, (MultiValueMap<String, String>)headers, info, args);
        for (Map.Entry<String, Object> entry : args.entrySet()) {
            key = entry.getKey();
            Object value = entry.getValue();
            boolean addToHeader = false;
            if (info.argsPosition != null && info.argsPosition.has(key)) {
                String position = info.argsPosition.path(key).asText();
                addToHeader = "header".equals(position);
            }
            if (!addToHeader || value == null) continue;
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                for (Object item : collection) {
                    requestSpec.header(key, new String[]{String.valueOf(item)});
                    headers.add((Object)key, (Object)String.valueOf(item));
                }
                continue;
            }
            requestSpec.header(key, new String[]{String.valueOf(value)});
            headers.add((Object)key, (Object)String.valueOf(value));
        }
        return headers;
    }

    public static String addPathVariables(String url, RequestTemplateInfo info, Map<String, Object> args) {
        if (url == null || url.isEmpty() || args == null || args.isEmpty()) {
            return url;
        }
        Matcher matcher = PATH_VARIABLES_PATTERN.matcher(url);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String position;
            String variableName = matcher.group(1);
            if (info.argsPosition == null || !info.argsPosition.has(variableName) || !"path".equals(position = info.argsPosition.path(variableName).asText())) continue;
            Object value = args.get(variableName);
            String replacement = value != null ? value.toString() : matcher.group(0);
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static WebClient.RequestHeadersSpec<?> addRequestBody(WebClient.RequestBodySpec requestSpec, MultiValueMap<String, String> headers, RequestTemplateInfo info, Map<String, Object> args, BiFunction<String, Map<String, Object>, String> templateProcessor, ObjectMapper objectMapper, Logger logger) {
        boolean hasBody = info.body != null && !info.body.asText().isEmpty();
        int optionCount = (hasBody ? 1 : 0) + (info.argsToJsonBody ? 1 : 0) + (info.argsToFormBody ? 1 : 0) + (info.argsToUrlParam ? 1 : 0);
        if (optionCount > 1) {
            throw new IllegalArgumentException("Only one of body, argsToJsonBody, argsToFormBody, or argsToUrlParam should be specified");
        }
        if (hasBody) {
            String bodyTemplate = info.body.asText();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("args", args);
            params.put("extendedData", "");
            String processedBody = templateProcessor.apply(bodyTemplate, params);
            return requestSpec.contentType(MediaType.APPLICATION_JSON).bodyValue((Object)processedBody);
        }
        String bodyType = info.argsToFormBody ? "form" : "json";
        LinkedMultiValueMap formData = new LinkedMultiValueMap();
        HashMap jsonData = new HashMap();
        if (!info.argsToJsonBody && !info.argsToFormBody) {
            String contentType = (String)headers.getFirst((Object)"Content-Type");
            bodyType = contentType != null && contentType.contains("application/x-www-form-urlencoded") ? "form" : "json";
        }
        for (Map.Entry entry : args.entrySet()) {
            boolean addToBody;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            boolean bl = addToBody = info.argsToFormBody || info.argsToJsonBody;
            if (info.argsPosition != null && info.argsPosition.has(key)) {
                String position = info.argsPosition.path(key).asText();
                addToBody = "body".equals(position);
            }
            if (!addToBody) continue;
            formData.add((Object)key, (Object)value.toString());
            jsonData.put(key, value);
        }
        if (formData.isEmpty()) {
            return requestSpec;
        }
        if ("json".equals(bodyType)) {
            try {
                String jsonBody = objectMapper.writeValueAsString(jsonData);
                return requestSpec.contentType(MediaType.APPLICATION_JSON).bodyValue((Object)jsonBody);
            }
            catch (JsonProcessingException e) {
                logger.error("Failed to create JSON request body", (Throwable)e);
                return requestSpec;
            }
        }
        return requestSpec.contentType(MediaType.APPLICATION_FORM_URLENCODED).body((BodyInserter)BodyInserters.fromFormData((MultiValueMap)formData));
    }
}

