/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.gateway.core.jsontemplate;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public class ResponseTemplateParser {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final Handlebars handlebars = new Handlebars();
    private static final Pattern TEMPLATE_PATTERN = Pattern.compile("\\{\\{\\s*\\.([\\w\\$\\[\\]\\.]*)\\s*}}", 32);
    private static final Pattern MULTI_LEVEL_PATTERN = Pattern.compile("\\{\\{\\s*\\.\\w+\\.[\\w\\.]+\\s*}}");

    public static String parse(String rawResponse, String responseTemplate) {
        if (!StringUtils.hasText((String)responseTemplate) || "{{.}}".equals(responseTemplate.trim())) {
            return rawResponse;
        }
        if (responseTemplate.trim().startsWith("$.") || responseTemplate.trim().startsWith("$[")) {
            try {
                Object result = JsonPath.read((String)rawResponse, (String)responseTemplate.trim(), (Predicate[])new Predicate[0]);
                return result != null ? result.toString() : "";
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (MULTI_LEVEL_PATTERN.matcher(responseTemplate).find()) {
            return ResponseTemplateParser.parseWithHandlebars(rawResponse, responseTemplate);
        }
        return ResponseTemplateParser.parseWithSimpleTemplate(rawResponse, responseTemplate);
    }

    private static String parseWithHandlebars(String rawResponse, String responseTemplate) {
        try {
            String handlebarsTemplateStr = responseTemplate.replaceAll("\\{\\{\\s*\\.", "{{").replaceAll("\\[([0-9]+)\\]", "$1");
            Template template = handlebars.compileInline(handlebarsTemplateStr);
            boolean isJson = rawResponse.trim().startsWith("{") || rawResponse.trim().startsWith("[");
            Map dataContext = isJson ? (Map)objectMapper.readValue(rawResponse, (TypeReference)new TypeReference<Map<String, Object>>(){}) : Map.of("_raw", rawResponse);
            return template.apply(dataContext);
        }
        catch (Exception e) {
            return ResponseTemplateParser.parseWithSimpleTemplate(rawResponse, responseTemplate);
        }
    }

    private static String parseWithSimpleTemplate(String rawResponse, String responseTemplate) {
        try {
            boolean isJson;
            Map context = null;
            boolean bl = isJson = rawResponse.trim().startsWith("{") || rawResponse.trim().startsWith("[");
            if (isJson) {
                context = (Map)objectMapper.readValue(rawResponse, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            StringBuffer sb = new StringBuffer();
            Matcher matcher = TEMPLATE_PATTERN.matcher(responseTemplate);
            while (matcher.find()) {
                String key = matcher.group(1);
                String value = key == null || key.isEmpty() ? rawResponse : (context != null && context.containsKey(key) ? String.valueOf(context.get(key)) : "");
                matcher.appendReplacement(sb, Matcher.quoteReplacement(value));
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
        catch (Exception e) {
            return rawResponse;
        }
    }
}

