/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.gateway.nacos.callback;

import com.alibaba.cloud.ai.mcp.gateway.core.McpGatewayToolDefinition;
import com.alibaba.cloud.ai.mcp.gateway.core.jsontemplate.RequestTemplateInfo;
import com.alibaba.cloud.ai.mcp.gateway.core.jsontemplate.RequestTemplateParser;
import com.alibaba.cloud.ai.mcp.gateway.core.utils.SpringBeanUtils;
import com.alibaba.cloud.ai.mcp.gateway.nacos.definition.NacosMcpGatewayToolDefinition;
import com.alibaba.cloud.ai.mcp.nacos.service.NacosMcpOperationService;
import com.alibaba.nacos.api.ai.model.mcp.McpEndpointInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerRemoteServiceConfig;
import com.alibaba.nacos.api.ai.model.mcp.McpServiceRef;
import com.alibaba.nacos.api.ai.model.mcp.McpToolMeta;
import com.alibaba.nacos.api.config.listener.AbstractListener;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.shaded.com.google.common.collect.Maps;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.client.McpClient;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.client.transport.HttpClientSseClientTransport;
import io.modelcontextprotocol.spec.McpClientTransport;
import io.modelcontextprotocol.spec.McpSchema;
import java.net.URI;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.definition.ToolDefinition;
import org.springframework.http.HttpMethod;
import org.springframework.lang.NonNull;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class NacosMcpGatewayToolCallback
implements ToolCallback {
    private static final Logger logger = LoggerFactory.getLogger(NacosMcpGatewayToolCallback.class);
    private static final Pattern TEMPLATE_PATTERN = Pattern.compile("\\{\\{\\s*(\\.[\\w]+(?:\\.[\\w]+)*)\\s*\\}\\}");
    private static final Pattern NACOS_TEMPLATE_PATTERN = Pattern.compile("\\{\\{\\s*\\$\\{nacos\\.([^}]+)\\}(\\.[\\w]+(?:\\.[\\w]+)*)?\\s*}}");
    static ObjectMapper objectMapper = new ObjectMapper();
    private final NacosMcpGatewayToolDefinition toolDefinition;
    private final NacosMcpOperationService nacosMcpOperationService;
    private final HashMap<String, AbstractListener> nacosConfigListeners = new HashMap();
    private final HashMap<String, String> nacosConfigContent = new HashMap();
    private final WebClient.Builder webClientBuilder = SpringBeanUtils.getInstance().getBean(WebClient.Builder.class);

    public NacosMcpGatewayToolCallback(McpGatewayToolDefinition toolDefinition) {
        this.toolDefinition = (NacosMcpGatewayToolDefinition)toolDefinition;
        this.nacosMcpOperationService = SpringBeanUtils.getInstance().getBean(NacosMcpOperationService.class);
    }

    private Mono<String> processToolRequest(String configJson, Map<String, Object> args, String baseUrl) {
        try {
            JsonNode toolConfig = objectMapper.readTree(configJson);
            logger.info("[processToolRequest] toolConfig: {} args: {} baseUrl: {}", new Object[]{toolConfig, args, baseUrl});
            if (toolConfig == null || toolConfig.isEmpty()) {
                return Mono.error((Throwable)new IllegalArgumentException("Tool configuration is empty or invalid"));
            }
            Map<String, Object> processedArgs = args;
            JsonNode requestTemplate = toolConfig.path("requestTemplate");
            JsonNode argsPosition = requestTemplate.path("argsPosition");
            String url = requestTemplate.path("url").asText();
            String method = requestTemplate.path("method").asText();
            logger.info("[processToolRequest] requestTemplate: {} url: {} method: {}", new Object[]{requestTemplate, url, method});
            if (url.isEmpty() || method.isEmpty()) {
                return Mono.error((Throwable)new IllegalArgumentException("URL and method are required in requestTemplate"));
            }
            try {
                HttpMethod.valueOf((String)method.toUpperCase());
            }
            catch (IllegalArgumentException e2) {
                return Mono.error((Throwable)new IllegalArgumentException("Invalid HTTP method: " + method));
            }
            baseUrl = baseUrl != null ? baseUrl : "http://localhost";
            WebClient client = this.webClientBuilder.baseUrl(baseUrl).build();
            return this.buildAndExecuteRequest(client, requestTemplate, argsPosition, toolConfig.path("responseTemplate"), processedArgs, baseUrl).onErrorResume(e -> {
                logger.error("Failed to execute tool request: {}", (Object)e.getMessage(), e);
                return Mono.error((Throwable)new RuntimeException("Tool execution failed: " + e.getMessage(), (Throwable)e));
            });
        }
        catch (Exception e3) {
            logger.error("Failed to process tool request", (Throwable)e3);
            return Mono.error((Throwable)new RuntimeException("Failed to process tool request: " + e3.getMessage(), e3));
        }
    }

    private Mono<String> buildAndExecuteRequest(WebClient client, JsonNode requestTemplate, JsonNode argsPosition, JsonNode responseTemplate, Map<String, Object> args, String baseUrl) {
        RequestTemplateInfo info = RequestTemplateParser.parseRequestTemplate(requestTemplate, argsPosition);
        String url = info.url;
        String method = info.method;
        HttpMethod httpMethod = HttpMethod.valueOf((String)method.toUpperCase());
        String processingUrl = RequestTemplateParser.addPathVariables(url, info, args);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("args", args);
        params.put("extendedData", "");
        String processedUrl = this.processTemplateString(processingUrl, params);
        logger.info("[buildAndExecuteRequest] original url template: {} processed url: {}", (Object)url, (Object)processedUrl);
        String hostFromUrl = this.extractHostFromUrl(processedUrl);
        String pathOnlyUrl = this.extractPathFromUrl(processedUrl);
        WebClient.RequestBodySpec requestBodySpec = (WebClient.RequestBodySpec)client.method(httpMethod).uri(builder -> RequestTemplateParser.buildUri(builder, pathOnlyUrl, info, args));
        MultiValueMap<String, String> headers = RequestTemplateParser.addHeaders(requestBodySpec, info, args, this::processTemplateString);
        if (hostFromUrl != null && !hostFromUrl.isEmpty()) {
            requestBodySpec.header("Host", new String[]{hostFromUrl});
            headers.add((Object)"Host", (Object)hostFromUrl);
        }
        WebClient.RequestHeadersSpec<?> headersSpec = RequestTemplateParser.addRequestBody(requestBodySpec, headers, info, args, this::processTemplateString, objectMapper, logger);
        String fullUrl = baseUrl.endsWith("/") && pathOnlyUrl.startsWith("/") ? baseUrl + pathOnlyUrl.substring(1) : baseUrl + pathOnlyUrl;
        logger.info("[buildAndExecuteRequest] final request: method={} url={} args={}", new Object[]{method, fullUrl, args});
        return headersSpec.retrieve().onStatus(status -> status.is4xxClientError(), response -> Mono.error((Throwable)new RuntimeException("Client error: " + response.statusCode()))).onStatus(status -> status.is5xxServerError(), response -> Mono.error((Throwable)new RuntimeException("Server error: " + response.statusCode()))).bodyToMono(String.class).timeout(this.getTimeoutDuration()).doOnNext(responseBody -> logger.info("[buildAndExecuteRequest] received responseBody: {}", responseBody)).map(responseBody -> this.processResponse((String)responseBody, responseTemplate, args)).onErrorResume(e -> {
            logger.error("[buildAndExecuteRequest] Request failed: {}", (Object)e.getMessage(), e);
            return Mono.error((Throwable)new RuntimeException("HTTP request failed: " + e.getMessage(), (Throwable)e));
        });
    }

    private String extractPathFromUrl(String url) {
        if (url == null || url.isEmpty()) {
            return url;
        }
        try {
            URI uri = URI.create(url);
            String path = uri.getPath();
            String query = uri.getQuery();
            if (path == null) {
                path = "";
            }
            if (query != null && !query.isEmpty()) {
                return path + "?" + query;
            }
            return path;
        }
        catch (Exception e) {
            logger.warn("[extractPathFromUrl] Failed to parse URL: {}", (Object)e.getMessage());
            return url;
        }
    }

    private String extractHostFromUrl(String url) {
        if (url == null || url.isEmpty()) {
            return null;
        }
        try {
            URI uri = URI.create(url);
            String host = uri.getHost();
            int port = uri.getPort();
            if (host != null && !host.isEmpty()) {
                if (port != -1) {
                    return host + ":" + port;
                }
                return host;
            }
        }
        catch (Exception e) {
            logger.warn("[extractHostFromUrl] Failed to parse URL: {}", (Object)e.getMessage());
        }
        return null;
    }

    private String processResponse(String responseBody, JsonNode responseTemplate, Map<String, Object> args) {
        logger.info("[processResponse] received responseBody: {}", (Object)responseBody);
        Object result = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("args", args);
        params.put("extendedData", responseBody);
        if (!responseTemplate.isEmpty()) {
            if (responseTemplate.has("body") && !responseTemplate.path("body").asText().isEmpty()) {
                String bodyTemplate = responseTemplate.path("body").asText();
                result = this.processTemplateString(bodyTemplate, params);
                logger.info("[processResponse] ResponseTemplateParser result: {}", result);
                return result;
            }
            if (responseTemplate.has("prependBody") || responseTemplate.has("appendBody")) {
                String prependText = responseTemplate.path("prependBody").asText("");
                String appendText = responseTemplate.path("appendBody").asText("");
                result = this.processTemplateString(prependText, params) + responseBody + this.processTemplateString(appendText, params);
                logger.info("[processResponse] prepend/append result: {}", result);
                return result;
            }
        }
        result = responseBody;
        logger.info("[processResponse] default result: {}", result);
        return result;
    }

    public String processNacosConfigRefTemplate(String template) {
        if (!StringUtils.hasText((String)template)) {
            return template;
        }
        StringBuffer result = new StringBuffer();
        Matcher matcher = NACOS_TEMPLATE_PATTERN.matcher(template);
        while (matcher.find()) {
            String dotNotation;
            String nacosRef = matcher.group(1);
            String replacement = this.resolveNacosReference(nacosRef, dotNotation = matcher.group(2));
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement != null ? replacement : ""));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private String resolveNacosReference(String nacosRef, String dotNotation) {
        if (!StringUtils.hasText((String)nacosRef)) {
            return null;
        }
        try {
            String[] configParts = nacosRef.split("/");
            if (configParts.length != 2) {
                throw new IllegalArgumentException("Invalid Nacos config reference format: " + nacosRef + ". Expected format: dataId/group");
            }
            String dataId = configParts[0];
            String group = configParts[1];
            String configContent = this.getConfigContent(dataId, group);
            if (!StringUtils.hasText((String)configContent)) {
                logger.warn("[resolveNacosReference] No content found for dataId: {}, group: {}", (Object)dataId, (Object)group);
                return null;
            }
            if (!StringUtils.hasText((String)dotNotation)) {
                return configContent;
            }
            String jsonPath = dotNotation.startsWith(".") ? dotNotation.substring(1) : dotNotation;
            return this.extractJsonValueFromNacos(configContent, jsonPath);
        }
        catch (Exception e) {
            logger.error("[resolveNacosReference] Failed to resolve Nacos reference: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("Failed to resolve Nacos reference: " + e.getMessage(), e);
        }
    }

    private String getConfigContent(String dataId, String group) throws NacosException {
        final String cacheKey = dataId + "@@" + group;
        if (this.nacosConfigContent.containsKey(cacheKey)) {
            return this.nacosConfigContent.get(cacheKey);
        }
        AbstractListener listener = new AbstractListener(){

            public void receiveConfigInfo(String configInfo) {
                NacosMcpGatewayToolCallback.this.nacosConfigContent.put(cacheKey, configInfo);
            }
        };
        AbstractListener oldListener = this.nacosConfigListeners.putIfAbsent(cacheKey, listener);
        if (oldListener == null) {
            try {
                this.nacosMcpOperationService.getConfigService().addListener(dataId, group, (Listener)listener);
            }
            catch (Exception e) {
                this.nacosConfigListeners.remove(cacheKey);
                logger.error("Failed to add listener for Nacos config: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return this.nacosMcpOperationService.getConfigService().getConfig(dataId, group, 3000L);
    }

    private String extractJsonValueFromNacos(String jsonString, String jsonPath) throws JsonProcessingException {
        try {
            JsonNode rootNode = objectMapper.readTree(jsonString);
            String[] pathParts = jsonPath.split("\\.");
            JsonNode currentNode = rootNode;
            for (String part : pathParts) {
                if (currentNode == null || currentNode.isMissingNode()) {
                    logger.warn("[extractJsonValueFromNacos] Path '{}' not found in JSON", (Object)jsonPath);
                    return null;
                }
                currentNode = currentNode.get(part);
            }
            if (currentNode == null || currentNode.isMissingNode()) {
                logger.warn("[extractJsonValueFromNacos] Final path '{}' not found in JSON", (Object)jsonPath);
                return null;
            }
            if (currentNode.isTextual()) {
                return currentNode.asText();
            }
            if (currentNode.isNumber()) {
                return currentNode.asText();
            }
            if (currentNode.isBoolean()) {
                return String.valueOf(currentNode.asBoolean());
            }
            return currentNode.toString();
        }
        catch (JsonProcessingException e) {
            logger.error("[extractJsonValueFromNacos] Failed to parse JSON from Nacos config. Content: {}, Error: {}", (Object)jsonString, (Object)e.getMessage());
            throw new RuntimeException("Nacos config content is not valid JSON, but dot notation was used. Please ensure the config is in JSON format or remove the dot notation. Content: " + jsonString, e);
        }
        catch (Exception e) {
            logger.error("[extractJsonValueFromNacos] Failed to extract JSON value from Nacos config: {}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
    }

    private String processTemplateString(String template, Map<String, Object> params) {
        Map args = (Map)params.get("args");
        String extendedData = (String)params.get("extendedData");
        logger.debug("[processTemplateString] template: {} args: {} extendedData: {}", new Object[]{template, args, extendedData});
        if (template == null || template.isEmpty()) {
            return "";
        }
        Matcher matcher = TEMPLATE_PATTERN.matcher(template);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String fullPath = matcher.group(1);
            String replacement = this.resolvePathValue(fullPath, args, extendedData);
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(result);
        String finalResult = result.toString();
        finalResult = this.processNacosConfigRefTemplate(finalResult);
        logger.debug("[processTemplateString] final result: {}", (Object)finalResult);
        return finalResult;
    }

    private String resolvePathValue(String fullPath, Map<String, Object> args, String extendedData) {
        int startIndex;
        Object dataSource;
        String[] pathParts;
        if (fullPath == null || fullPath.isEmpty()) {
            return "";
        }
        if (fullPath.startsWith(".")) {
            fullPath = fullPath.substring(1);
        }
        if ((pathParts = fullPath.split("\\.")).length == 0) {
            return "";
        }
        if (pathParts[0].equals("args")) {
            dataSource = args;
            if (pathParts.length == 1) {
                if (args != null && args.size() == 1) {
                    return String.valueOf(args.values().iterator().next());
                }
                if (args != null && !args.isEmpty()) {
                    return args.toString();
                }
                return "";
            }
        } else {
            try {
                dataSource = StringUtils.hasText((String)extendedData) ? objectMapper.readValue(extendedData, Map.class) : null;
            }
            catch (Exception e) {
                logger.warn("[resolvePathValue] Failed to parse extendedData as JSON: {}", (Object)e.getMessage());
                if (pathParts.length == 1 && fullPath.equals("extendedData")) {
                    return extendedData != null ? extendedData : "";
                }
                return "";
            }
            if (pathParts.length == 1 && fullPath.equals("extendedData")) {
                return extendedData != null ? extendedData : "";
            }
        }
        if (dataSource == null) {
            return "";
        }
        Object currentValue = dataSource;
        for (int i = startIndex = pathParts[0].equals("args") ? 1 : 0; i < pathParts.length; ++i) {
            String key = pathParts[i];
            if (!(currentValue instanceof Map)) {
                logger.warn("[resolvePathValue] Cannot access key '{}' from non-map value", (Object)key);
                return "";
            }
            Map<String, Object> currentMap = currentValue;
            currentValue = currentMap.get(key);
            if (currentValue != null) continue;
            logger.warn("[resolvePathValue] Key '{}' not found in nested path", (Object)key);
            return "";
        }
        return currentValue.toString();
    }

    public ToolDefinition getToolDefinition() {
        return this.toolDefinition;
    }

    public String call(@NonNull String input) {
        return this.call(input, new ToolContext((Map)Maps.newHashMap()));
    }

    public String call(@NonNull String input, ToolContext toolContext) {
        try {
            String protocol;
            logger.info("[call] input: {} toolContext: {}", (Object)input, (Object)JacksonUtils.toJson((Object)toolContext));
            if (this.toolDefinition == null) {
                throw new IllegalStateException("Tool definition is null");
            }
            logger.info("[call] input string: {}", (Object)input);
            Map<String, Object> args = new HashMap();
            if (!input.isEmpty()) {
                try {
                    args = (Map)objectMapper.readValue(input, Map.class);
                    logger.info("[call] parsed args: {}", args);
                }
                catch (Exception e) {
                    logger.error("[call] Failed to parse input to args", (Throwable)e);
                    args.put("input", input);
                }
            }
            if ((protocol = this.toolDefinition.getProtocol()) == null) {
                throw new IllegalStateException("Protocol is null");
            }
            if ("http".equalsIgnoreCase(protocol) || "https".equalsIgnoreCase(protocol)) {
                McpServerRemoteServiceConfig remoteServerConfig = this.toolDefinition.getRemoteServerConfig();
                if (remoteServerConfig == null) {
                    throw new IllegalStateException("Remote server config is null");
                }
                return this.handleHttpHttpsProtocol(args, remoteServerConfig, protocol);
            }
            if ("mcp-sse".equalsIgnoreCase(protocol)) {
                McpServerRemoteServiceConfig remoteServerConfig = this.toolDefinition.getRemoteServerConfig();
                if (remoteServerConfig == null) {
                    throw new IllegalStateException("Remote server config is null");
                }
                return this.handleMcpStreamProtocol(args, remoteServerConfig, protocol);
            }
            if ("mcp-streamable".equalsIgnoreCase(protocol)) {
                logger.error("[call] Unsupported protocol: {}", (Object)protocol);
                return "Error: Unsupported protocol " + protocol;
            }
            logger.error("[call] Unsupported protocol: {}", (Object)protocol);
            return "Error: Unsupported protocol " + protocol;
        }
        catch (Exception e) {
            logger.error("[call] Unexpected error occurred", (Throwable)e);
            return "Error: " + e.getMessage();
        }
    }

    private String handleHttpHttpsProtocol(Map<String, Object> args, McpServerRemoteServiceConfig remoteServerConfig, String protocol) throws NacosException {
        McpServiceRef serviceRef = remoteServerConfig.getServiceRef();
        if (serviceRef != null) {
            McpEndpointInfo mcpEndpointInfo = this.nacosMcpOperationService.selectEndpoint(serviceRef);
            if (mcpEndpointInfo == null) {
                throw new RuntimeException("No available endpoint found for service: " + serviceRef.getServiceName());
            }
            logger.info("Tool callback instance: {}", (Object)JacksonUtils.toJson((Object)mcpEndpointInfo));
            McpToolMeta toolMeta = this.toolDefinition.getToolMeta();
            String baseUrl = protocol + "://" + mcpEndpointInfo.getAddress() + ":" + mcpEndpointInfo.getPort();
            if (toolMeta != null && toolMeta.getTemplates() != null) {
                Map templates = toolMeta.getTemplates();
                if (templates != null && templates.containsKey("json-go-template")) {
                    Object jsonGoTemplate = templates.get("json-go-template");
                    try {
                        logger.info("[handleHttpHttpsProtocol] json-go-template: {}", (Object)objectMapper.writeValueAsString(jsonGoTemplate));
                    }
                    catch (JsonProcessingException e) {
                        logger.error("[handleHttpHttpsProtocol] Failed to serialize json-go-template", (Throwable)e);
                    }
                    try {
                        String configJson = objectMapper.writeValueAsString(jsonGoTemplate);
                        logger.info("[handleHttpHttpsProtocol] configJson: {} args: {} baseUrl: {}", new Object[]{configJson, args, baseUrl});
                        return (String)this.processToolRequest(configJson, args, baseUrl).block();
                    }
                    catch (Exception e) {
                        logger.error("Failed to execute tool request", (Throwable)e);
                        return "Error: " + e.getMessage();
                    }
                }
                logger.warn("[handleHttpHttpsProtocol] json-go-template not found in templates");
                return "Error: json-go-template not found in tool configuration";
            }
            logger.warn("[handleHttpHttpsProtocol] templates not found in toolsMeta");
            return "Error: templates not found in tool metadata";
        }
        logger.error("[handleHttpHttpsProtocol] serviceRef is null");
        return "Error: service reference is null";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String handleMcpStreamProtocol(Map<String, Object> args, McpServerRemoteServiceConfig remoteServerConfig, String protocol) throws NacosException {
        McpServiceRef serviceRef = remoteServerConfig.getServiceRef();
        if (serviceRef == null) {
            logger.error("[handleMcpStreamProtocol] serviceRef is null");
            return "Error: service reference is null";
        }
        McpEndpointInfo mcpEndpointInfo = this.nacosMcpOperationService.selectEndpoint(serviceRef);
        if (mcpEndpointInfo == null) {
            throw new RuntimeException("No available endpoint found for service: " + serviceRef.getServiceName());
        }
        logger.info("[handleMcpStreamProtocol] Tool callback instance: {}", (Object)JacksonUtils.toJson((Object)mcpEndpointInfo));
        String exportPath = remoteServerConfig.getExportPath();
        String baseUrl = "mcp-sse".equalsIgnoreCase(protocol) ? "http://" + mcpEndpointInfo.getAddress() + ":" + mcpEndpointInfo.getPort() : "http://" + mcpEndpointInfo.getAddress() + ":" + mcpEndpointInfo.getPort();
        logger.info("[handleMcpStreamProtocol] Processing {} protocol with args: {} and baseUrl: {}", new Object[]{protocol, args, baseUrl});
        try {
            String toolDefinitionName = this.toolDefinition.name();
            if (toolDefinitionName == null) throw new RuntimeException("Tool definition name is not available");
            if (toolDefinitionName.isEmpty()) {
                throw new RuntimeException("Tool definition name is not available");
            }
            String toolName = toolDefinitionName.contains("_tools_") ? toolDefinitionName.substring(toolDefinitionName.lastIndexOf("_tools_") + 7) : toolDefinitionName;
            if (toolName.isEmpty()) {
                throw new RuntimeException("Extracted tool name is empty");
            }
            String sseEndpoint = "/sse";
            if (exportPath != null && !exportPath.isEmpty()) {
                sseEndpoint = exportPath;
            }
            HttpClientSseClientTransport.Builder transportBuilder = HttpClientSseClientTransport.builder((String)baseUrl).sseEndpoint(sseEndpoint);
            HttpClientSseClientTransport transport = transportBuilder.build();
            McpSyncClient client = McpClient.sync((McpClientTransport)transport).build();
            try {
                List list;
                McpSchema.InitializeResult initializeResult = client.initialize();
                logger.info("[handleMcpStreamProtocol] MCP Client initialized: {}", (Object)initializeResult);
                McpSchema.CallToolRequest request = new McpSchema.CallToolRequest(toolName, args);
                logger.info("[handleMcpStreamProtocol] CallToolRequest: {}", (Object)request);
                McpSchema.CallToolResult result = client.callTool(request);
                logger.info("[handleMcpStreamProtocol] tool call result: {}", (Object)result);
                List content = result.content();
                if (content instanceof List && !CollectionUtils.isEmpty((Collection)(list = content))) {
                    Map map;
                    Object first = list.get(0);
                    if (first instanceof McpSchema.TextContent) {
                        McpSchema.TextContent textContent = (McpSchema.TextContent)first;
                        String string = textContent.text();
                        return string;
                    }
                    if (first instanceof Map && (map = (Map)first).containsKey("text")) {
                        String string = map.get("text").toString();
                        return string;
                    }
                    String string = first.toString();
                    return string;
                }
                String string = content != null ? content.toString() : "No content returned";
                return string;
            }
            finally {
                try {
                    if (client != null) {
                        client.close();
                    }
                }
                catch (Exception e) {
                    logger.warn("[handleMcpStreamProtocol] Failed to close MCP client", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error("[handleMcpStreamProtocol] MCP call failed:", (Throwable)e);
            return "Error: MCP call failed - " + e.getMessage();
        }
    }

    private Duration getTimeoutDuration() {
        return Duration.ofSeconds(30L);
    }

    public void close() {
        for (Map.Entry<String, AbstractListener> entry : this.nacosConfigListeners.entrySet()) {
            String cacheKey = entry.getKey();
            String dataId = cacheKey.split("@@")[0];
            String group = cacheKey.split("@@")[1];
            this.nacosMcpOperationService.getConfigService().removeListener(dataId, group, (Listener)entry.getValue());
        }
    }

    static {
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

