/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.gateway.nacos.provider;

import com.alibaba.cloud.ai.mcp.gateway.core.McpGatewayToolDefinition;
import com.alibaba.cloud.ai.mcp.gateway.core.McpGatewayToolManager;
import com.alibaba.cloud.ai.mcp.gateway.nacos.callback.NacosMcpGatewayToolCallback;
import io.modelcontextprotocol.server.McpAsyncServer;
import java.util.HashMap;
import java.util.Map;
import org.springframework.ai.mcp.McpToolUtils;
import org.springframework.ai.tool.ToolCallback;

public class NacosMcpAsyncGatewayToolsProvider
implements McpGatewayToolManager {
    private final McpAsyncServer mcpAsyncServer;
    private final Map<String, NacosMcpGatewayToolCallback> toolCallbacks = new HashMap<String, NacosMcpGatewayToolCallback>();

    public NacosMcpAsyncGatewayToolsProvider(McpAsyncServer mcpAsyncServer) {
        this.mcpAsyncServer = mcpAsyncServer;
    }

    @Override
    public void addTool(McpGatewayToolDefinition toolDefinition) {
        try {
            this.removeTool(toolDefinition.name());
        }
        catch (Exception exception) {
            // empty catch block
        }
        NacosMcpGatewayToolCallback toolCallback = new NacosMcpGatewayToolCallback(toolDefinition);
        this.toolCallbacks.put(toolDefinition.name(), toolCallback);
        this.mcpAsyncServer.addTool(McpToolUtils.toAsyncToolSpecification((ToolCallback)toolCallback)).block();
    }

    @Override
    public void removeTool(String toolName) {
        NacosMcpGatewayToolCallback toolCallback = this.toolCallbacks.remove(toolName);
        if (toolCallback != null) {
            toolCallback.close();
        }
        this.mcpAsyncServer.removeTool(toolName).block();
    }
}

