/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.gateway.nacos.provider;

import com.alibaba.cloud.ai.mcp.gateway.core.McpGatewayToolDefinition;
import com.alibaba.cloud.ai.mcp.gateway.core.McpGatewayToolManager;
import com.alibaba.cloud.ai.mcp.gateway.nacos.callback.NacosMcpGatewayToolCallback;
import io.modelcontextprotocol.server.McpSyncServer;
import java.util.HashMap;
import java.util.Map;
import org.springframework.ai.mcp.McpToolUtils;
import org.springframework.ai.tool.ToolCallback;

public class NacosMcpSyncGatewayToolsProvider
implements McpGatewayToolManager {
    private final McpSyncServer mcpSyncServer;
    private final Map<String, NacosMcpGatewayToolCallback> toolCallbacks = new HashMap<String, NacosMcpGatewayToolCallback>();

    public NacosMcpSyncGatewayToolsProvider(McpSyncServer mcpSyncServer) {
        this.mcpSyncServer = mcpSyncServer;
    }

    @Override
    public void addTool(McpGatewayToolDefinition toolDefinition) {
        try {
            this.removeTool(toolDefinition.name());
        }
        catch (Exception exception) {
            // empty catch block
        }
        NacosMcpGatewayToolCallback toolCallback = new NacosMcpGatewayToolCallback(toolDefinition);
        this.toolCallbacks.put(toolDefinition.name(), toolCallback);
        this.mcpSyncServer.addTool(McpToolUtils.toSyncToolSpecification((ToolCallback)toolCallback));
    }

    @Override
    public void removeTool(String toolName) {
        NacosMcpGatewayToolCallback toolCallback = this.toolCallbacks.remove(toolName);
        if (toolCallback != null) {
            toolCallback.close();
        }
        this.mcpSyncServer.removeTool(toolName);
    }
}

