/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.gateway.nacos.tools;

import com.alibaba.cloud.ai.mcp.gateway.core.McpGatewayToolsInitializer;
import com.alibaba.cloud.ai.mcp.gateway.nacos.callback.NacosMcpGatewayToolCallback;
import com.alibaba.cloud.ai.mcp.gateway.nacos.definition.NacosMcpGatewayToolDefinition;
import com.alibaba.cloud.ai.mcp.gateway.nacos.properties.NacosMcpGatewayProperties;
import com.alibaba.cloud.ai.mcp.nacos.service.NacosMcpOperationService;
import com.alibaba.nacos.api.ai.model.mcp.McpServerDetailInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerRemoteServiceConfig;
import com.alibaba.nacos.api.ai.model.mcp.McpTool;
import com.alibaba.nacos.api.ai.model.mcp.McpToolMeta;
import com.alibaba.nacos.api.ai.model.mcp.McpToolSpecification;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.tool.ToolCallback;

public class NacosMcpGatewayToolsInitializer
implements McpGatewayToolsInitializer {
    private static final Logger logger = LoggerFactory.getLogger(NacosMcpGatewayToolsInitializer.class);
    private final NacosMcpGatewayProperties nacosMcpGatewayProperties;
    private final NacosMcpOperationService nacosMcpOperationService;

    public NacosMcpGatewayToolsInitializer(NacosMcpOperationService nacosMcpOperationService, NacosMcpGatewayProperties nacosMcpGatewayProperties) {
        this.nacosMcpGatewayProperties = nacosMcpGatewayProperties;
        this.nacosMcpOperationService = nacosMcpOperationService;
    }

    @Override
    public List<ToolCallback> initializeTools() {
        List<String> serviceNames = this.nacosMcpGatewayProperties.getServiceNames();
        if (serviceNames == null || serviceNames.isEmpty()) {
            logger.warn("No service names configured, no tools will be initialized");
            return new ArrayList<ToolCallback>();
        }
        ArrayList<ToolCallback> allTools = new ArrayList<ToolCallback>();
        for (String serviceName : serviceNames) {
            try {
                McpServerDetailInfo serviceDetail = this.nacosMcpOperationService.getServerDetail(serviceName);
                if (serviceDetail == null) {
                    logger.warn("No service detail info found for service: {}", (Object)serviceName);
                    continue;
                }
                String protocol = serviceDetail.getProtocol();
                if ("http".equalsIgnoreCase(protocol) || "https".equalsIgnoreCase(protocol) || "mcp-sse".equalsIgnoreCase(protocol) || "mcp-streamable".equalsIgnoreCase(protocol)) {
                    List<ToolCallback> tools = this.parseToolsFromMcpServerDetailInfo(serviceDetail);
                    if (CollectionUtils.isEmpty(tools)) {
                        logger.warn("No tools defined for service: {}", (Object)serviceName);
                        continue;
                    }
                    allTools.addAll(tools);
                    continue;
                }
                logger.error("protocol {} is not supported yet. Check your configuration for valid tool protocols", (Object)protocol);
            }
            catch (Exception e) {
                logger.error("Failed to initialize tools for service: {}", (Object)serviceName, (Object)e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Initial dynamic tools loading completed - Found {} tools", (Object)allTools.size());
        }
        return allTools;
    }

    private List<ToolCallback> parseToolsFromMcpServerDetailInfo(McpServerDetailInfo mcpServerDetailInfo) {
        try {
            McpToolSpecification toolSpecification = mcpServerDetailInfo.getToolSpec();
            String protocol = mcpServerDetailInfo.getProtocol();
            McpServerRemoteServiceConfig mcpServerRemoteServiceConfig = mcpServerDetailInfo.getRemoteServerConfig();
            ArrayList<ToolCallback> toolCallbacks = new ArrayList<ToolCallback>();
            if (toolSpecification != null) {
                List toolsList = toolSpecification.getTools();
                Map toolsMeta = toolSpecification.getToolsMeta();
                if (toolsList == null || toolsMeta == null) {
                    return new ArrayList<ToolCallback>();
                }
                for (McpTool tool : toolsList) {
                    boolean enabled;
                    String toolName = tool.getName();
                    String toolDescription = tool.getDescription();
                    Map inputSchema = tool.getInputSchema();
                    McpToolMeta metaInfo = (McpToolMeta)toolsMeta.get(toolName);
                    boolean bl = enabled = metaInfo == null || metaInfo.isEnabled();
                    if (!enabled) {
                        logger.info("Tool {} is disabled by metaInfo, skipping.", (Object)toolName);
                        continue;
                    }
                    NacosMcpGatewayToolDefinition toolDefinition = NacosMcpGatewayToolDefinition.builder().name(mcpServerDetailInfo.getName() + "_tools_" + toolName).description(toolDescription).inputSchema(inputSchema).protocol(protocol).remoteServerConfig(mcpServerRemoteServiceConfig).toolsMeta(metaInfo).build();
                    toolCallbacks.add(new NacosMcpGatewayToolCallback(toolDefinition));
                }
            }
            return toolCallbacks;
        }
        catch (Exception e) {
            logger.warn("Failed to get or parse nacos mcp service tools info (mcpName {})", (Object)(mcpServerDetailInfo.getName() + mcpServerDetailInfo.getVersionDetail().getVersion()), (Object)e);
            return null;
        }
    }
}

