/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.gateway.nacos.watcher;

import com.alibaba.cloud.ai.mcp.gateway.core.AbstractMcpGatewayToolsWatcher;
import com.alibaba.cloud.ai.mcp.gateway.core.McpGatewayToolManager;
import com.alibaba.cloud.ai.mcp.gateway.nacos.definition.NacosMcpGatewayToolDefinition;
import com.alibaba.cloud.ai.mcp.gateway.nacos.properties.NacosMcpGatewayProperties;
import com.alibaba.cloud.ai.mcp.nacos.service.NacosMcpOperationService;
import com.alibaba.nacos.api.ai.model.mcp.McpServerDetailInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerRemoteServiceConfig;
import com.alibaba.nacos.api.ai.model.mcp.McpServiceRef;
import com.alibaba.nacos.api.ai.model.mcp.McpTool;
import com.alibaba.nacos.api.ai.model.mcp.McpToolMeta;
import com.alibaba.nacos.api.ai.model.mcp.McpToolSpecification;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosMcpGatewayToolsWatcher
extends AbstractMcpGatewayToolsWatcher {
    private static final Logger logger = LoggerFactory.getLogger(NacosMcpGatewayToolsWatcher.class);
    private final NacosMcpGatewayProperties nacosMcpGatewayProperties;
    private final NacosMcpOperationService nacosMcpOperationService;
    private final Map<String, McpServerDetailInfo> serviceDetailInfoCache = new ConcurrentHashMap<String, McpServerDetailInfo>();

    public NacosMcpGatewayToolsWatcher(McpGatewayToolManager mcpGatewayToolManager, NacosMcpOperationService nacosMcpOperationService, NacosMcpGatewayProperties nacosMcpGatewayProperties) {
        super(mcpGatewayToolManager);
        if (nacosMcpGatewayProperties == null) {
            throw new IllegalArgumentException("NacosMcpGatewayProperties cannot be null");
        }
        this.nacosMcpOperationService = nacosMcpOperationService;
        this.nacosMcpGatewayProperties = nacosMcpGatewayProperties;
    }

    @Override
    public void stop() {
        super.stop();
        this.serviceDetailInfoCache.clear();
    }

    private void cleanupStaleServices(Set<String> currentServices) {
        HashSet<String> staleServices = new HashSet<String>(this.serviceDetailInfoCache.keySet());
        staleServices.removeAll(currentServices);
        for (String staleService : staleServices) {
            McpServerDetailInfo staleServerDetail = this.serviceDetailInfoCache.get(staleService);
            McpToolSpecification mcpToolSpec = staleServerDetail.getToolSpec();
            if (mcpToolSpec != null) {
                List toolsToRemove = mcpToolSpec.getTools();
                if (toolsToRemove == null) continue;
                for (McpTool tool : toolsToRemove) {
                    String toolName = tool.getName();
                    try {
                        logger.info("Removing tool: {} for stale service: {}", (Object)toolName, (Object)staleService);
                        this.toolManager.removeTool(staleServerDetail.getName() + "_tools_" + toolName);
                    }
                    catch (Exception e) {
                        logger.error("Failed to remove tool: {} for service: {}", new Object[]{toolName, staleService, e});
                    }
                    this.toolManager.removeTool(staleServerDetail.getName() + "_tools_" + tool.getName());
                }
            }
            this.serviceDetailInfoCache.remove(staleService);
        }
    }

    @Override
    public void handleChange() {
        List<String> serviceNames = this.nacosMcpGatewayProperties.getServiceNames();
        if (CollectionUtils.isEmpty(serviceNames)) {
            logger.warn("No service names configured, no tools will be watched");
            return;
        }
        HashSet<String> currentServices = new HashSet<String>(serviceNames);
        for (String serviceName : serviceNames) {
            try {
                this.updateHighVersionServiceTools(serviceName);
            }
            catch (Exception e) {
                logger.error("Failed to update tools for service: {}", (Object)serviceName, (Object)e);
            }
        }
        this.cleanupStaleServices(currentServices);
    }

    private void compareToolsChange(McpServerDetailInfo oldMcpServerDetail, McpServerDetailInfo mcpServerDetail, Set<String> needToDeleteTools, Set<String> needToUpdateTools) {
        boolean isSameService;
        String newProtocol;
        boolean isHaveOldTools = true;
        boolean isHaveNewTools = true;
        if (oldMcpServerDetail == null || oldMcpServerDetail.getToolSpec() == null || oldMcpServerDetail.getToolSpec().getTools() == null || oldMcpServerDetail.getToolSpec().getToolsMeta() == null) {
            isHaveOldTools = false;
        }
        if (mcpServerDetail == null || mcpServerDetail.getToolSpec() == null || mcpServerDetail.getToolSpec().getTools() == null || mcpServerDetail.getToolSpec().getToolsMeta() == null) {
            isHaveNewTools = false;
        }
        String oldProtocol = null;
        if (oldMcpServerDetail != null) {
            oldProtocol = oldMcpServerDetail.getProtocol();
        }
        if (!(StringUtils.equals((String)oldProtocol, (String)"http") || StringUtils.equals((String)oldProtocol, (String)"https") || StringUtils.equals((String)oldProtocol, (String)"mcp-sse") || StringUtils.equals((String)oldProtocol, (String)"mcp-streamable"))) {
            isHaveOldTools = false;
        }
        if (!(StringUtils.equals((String)(newProtocol = mcpServerDetail.getProtocol()), (String)"http") || StringUtils.equals((String)newProtocol, (String)"https") || StringUtils.equals((String)newProtocol, (String)"mcp-sse") || StringUtils.equals((String)newProtocol, (String)"mcp-streamable"))) {
            isHaveNewTools = false;
        }
        if (!isHaveOldTools && isHaveNewTools) {
            List tools = mcpServerDetail.getToolSpec().getTools();
            Map toolsMeta = mcpServerDetail.getToolSpec().getToolsMeta();
            for (McpTool tool : tools) {
                String toolName = tool.getName();
                if (toolsMeta == null || toolsMeta.get(toolName) == null || !((McpToolMeta)toolsMeta.get(toolName)).isEnabled()) continue;
                needToUpdateTools.add(toolName);
            }
            return;
        }
        if (isHaveOldTools && !isHaveNewTools) {
            List tools = oldMcpServerDetail.getToolSpec().getTools();
            Map toolsMeta = oldMcpServerDetail.getToolSpec().getToolsMeta();
            for (McpTool tool : tools) {
                String toolName = tool.getName();
                if (toolsMeta == null || toolsMeta.get(toolName) == null || !((McpToolMeta)toolsMeta.get(toolName)).isEnabled()) continue;
                needToDeleteTools.add(toolName);
            }
            return;
        }
        if (!isHaveOldTools && !isHaveNewTools) {
            return;
        }
        List oldTools = oldMcpServerDetail.getToolSpec().getTools();
        List newTools = mcpServerDetail.getToolSpec().getTools();
        Map oldToolsMeta = oldMcpServerDetail.getToolSpec().getToolsMeta();
        Map newToolsMeta = mcpServerDetail.getToolSpec().getToolsMeta();
        HashMap<String, McpTool> oldAvailableToolMap = new HashMap<String, McpTool>();
        HashMap<String, McpTool> newAvailableToolMap = new HashMap<String, McpTool>();
        for (McpTool tool : oldTools) {
            if (oldToolsMeta == null || oldToolsMeta.get(tool.getName()) == null || !((McpToolMeta)oldToolsMeta.get(tool.getName())).isEnabled()) continue;
            oldAvailableToolMap.put(tool.getName(), tool);
        }
        for (McpTool tool : newTools) {
            if (newToolsMeta == null || newToolsMeta.get(tool.getName()) == null || !((McpToolMeta)newToolsMeta.get(tool.getName())).isEnabled()) continue;
            newAvailableToolMap.put(tool.getName(), tool);
        }
        String oldVersion = oldMcpServerDetail.getVersionDetail().getVersion();
        String newVersion = mcpServerDetail.getVersionDetail().getVersion();
        McpServiceRef oldServiceRef = oldMcpServerDetail.getRemoteServerConfig().getServiceRef();
        McpServiceRef newServiceRef = mcpServerDetail.getRemoteServerConfig().getServiceRef();
        boolean bl = isSameService = StringUtils.equals((String)oldServiceRef.getServiceName(), (String)newServiceRef.getServiceName()) && StringUtils.equals((String)oldServiceRef.getNamespaceId(), (String)newServiceRef.getNamespaceId()) && StringUtils.equals((String)oldServiceRef.getGroupName(), (String)newServiceRef.getGroupName());
        if (!(StringUtils.equals((String)oldVersion, (String)newVersion) && isSameService && StringUtils.equals((String)oldProtocol, (String)newProtocol))) {
            needToUpdateTools.addAll(newAvailableToolMap.keySet());
            needToDeleteTools.addAll(oldAvailableToolMap.keySet());
            needToDeleteTools.removeAll(needToUpdateTools);
            return;
        }
        for (String toolName : newAvailableToolMap.keySet()) {
            if (!oldAvailableToolMap.containsKey(toolName)) {
                needToUpdateTools.add(toolName);
                continue;
            }
            McpTool newTool = (McpTool)newAvailableToolMap.get(toolName);
            McpTool oldTool = (McpTool)oldAvailableToolMap.get(toolName);
            McpToolMeta newToolMeta = (McpToolMeta)newToolsMeta.get(toolName);
            McpToolMeta oldToolMeta = (McpToolMeta)oldToolsMeta.get(toolName);
            boolean isSameTool = StringUtils.equals((String)JacksonUtils.toJson((Object)newTool), (String)JacksonUtils.toJson((Object)oldTool));
            boolean isSameMeta = StringUtils.equals((String)JacksonUtils.toJson((Object)newToolMeta), (String)JacksonUtils.toJson((Object)oldToolMeta));
            if (!isSameTool || !isSameMeta) {
                needToUpdateTools.add(toolName);
            }
            oldAvailableToolMap.remove(toolName);
        }
        needToDeleteTools.addAll(oldAvailableToolMap.keySet());
    }

    private void updateHighVersionServiceTools(String mcpName) {
        try {
            McpServerDetailInfo mcpServerDetail = this.nacosMcpOperationService.getServerDetail(mcpName);
            if (mcpServerDetail == null) {
                logger.warn("No service detail info found for service: {},do not update", (Object)mcpName);
                return;
            }
            McpServerDetailInfo oldMcpServerDetail = this.serviceDetailInfoCache.get(mcpName);
            this.serviceDetailInfoCache.put(mcpName, mcpServerDetail);
            HashSet<String> needToDeleteTools = new HashSet<String>();
            HashSet<String> needToUpdateTools = new HashSet<String>();
            this.compareToolsChange(oldMcpServerDetail, mcpServerDetail, needToDeleteTools, needToUpdateTools);
            if (logger.isDebugEnabled()) {
                logger.debug("Nacos mcp service info (name {}): {}", (Object)mcpName, (Object)JacksonUtils.toJson((Object)mcpServerDetail));
            }
            McpToolSpecification toolSpec = mcpServerDetail.getToolSpec();
            McpServerRemoteServiceConfig remoteServerConfig = mcpServerDetail.getRemoteServerConfig();
            String protocol = mcpServerDetail.getProtocol();
            if (logger.isDebugEnabled()) {
                logger.debug("Need to update tools (name {}): {}", (Object)mcpName, (Object)JacksonUtils.toJson(needToUpdateTools));
                logger.debug("Need to delete tools (name {}): {}", (Object)mcpName, (Object)JacksonUtils.toJson(needToUpdateTools));
            }
            if (!needToUpdateTools.isEmpty()) {
                List tools = toolSpec.getTools();
                Map toolsMeta = toolSpec.getToolsMeta();
                for (McpTool tool : tools) {
                    if (!needToUpdateTools.contains(tool.getName())) {
                        return;
                    }
                    String toolName = tool.getName();
                    String toolDescription = tool.getDescription();
                    Map inputSchema = tool.getInputSchema();
                    McpToolMeta metaInfo = (McpToolMeta)toolsMeta.get(toolName);
                    NacosMcpGatewayToolDefinition toolDefinition = NacosMcpGatewayToolDefinition.builder().name(mcpServerDetail.getName() + "_tools_" + toolName).description(toolDescription).inputSchema(inputSchema).protocol(protocol).remoteServerConfig(remoteServerConfig).toolsMeta(metaInfo).build();
                    this.toolManager.addTool(toolDefinition);
                }
            }
            if (!needToDeleteTools.isEmpty()) {
                for (String toolName : needToDeleteTools) {
                    this.toolManager.removeTool(mcpServerDetail.getName() + "_tools_" + toolName);
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed to update tools for high version service: {}", (Object)mcpName, (Object)e);
        }
    }
}

