/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.router.core;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRouterWatcher {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractRouterWatcher.class);
    protected final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();

    protected void startScheduledPolling() {
        long interval = Math.max(1L, this.getPollingInterval());
        this.scheduler.scheduleAtFixedRate(this::watch, interval, interval, TimeUnit.SECONDS);
        logger.info("Started router watcher polling, interval: {}s", (Object)interval);
    }

    public void stop() {
        this.scheduler.shutdown();
        logger.info("Stopped router watcher polling");
    }

    protected void watch() {
        try {
            this.handleChange();
        }
        catch (Exception e) {
            logger.error("Error in router watcher", (Throwable)e);
        }
    }

    protected abstract void handleChange();

    protected long getPollingInterval() {
        return 30L;
    }
}

