/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.router.core;

import com.alibaba.cloud.ai.mcp.router.core.AbstractRouterWatcher;
import com.alibaba.cloud.ai.mcp.router.core.discovery.McpServiceDiscovery;
import com.alibaba.cloud.ai.mcp.router.core.vectorstore.McpServerVectorStore;
import com.alibaba.cloud.ai.mcp.router.model.McpServerInfo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpRouterWatcher
extends AbstractRouterWatcher {
    private static final Logger logger = LoggerFactory.getLogger(McpRouterWatcher.class);
    private final McpServiceDiscovery mcpServiceDiscovery;
    private final McpServerVectorStore mcpServerVectorStore;
    private final List<String> serviceNames;

    public McpRouterWatcher(McpServiceDiscovery mcpServiceDiscovery, McpServerVectorStore mcpServerVectorStore, List<String> serviceNames) {
        this.serviceNames = serviceNames;
        this.mcpServiceDiscovery = mcpServiceDiscovery;
        this.mcpServerVectorStore = mcpServerVectorStore;
    }

    @Override
    protected void handleChange() {
        logger.debug("McpRouterWatcher polling...");
        if (this.serviceNames == null || this.serviceNames.isEmpty()) {
            logger.warn("No MCP services configured for refresh.");
            return;
        }
        for (String serviceName : this.serviceNames) {
            try {
                this.mcpServerVectorStore.removeServer(serviceName);
                McpServerInfo serverInfo = this.mcpServiceDiscovery.getService(serviceName);
                if (serverInfo == null) {
                    logger.warn("No MCP service found for: {}", (Object)serviceName);
                    return;
                }
                this.mcpServerVectorStore.addServer(serverInfo);
                logger.info("Refreshed MCP service: {}", (Object)serviceName);
            }
            catch (Exception e) {
                logger.warn("Failed to refresh MCP service: {}", (Object)serviceName, (Object)e);
            }
        }
    }
}

