/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.router.core.discovery;

import com.alibaba.cloud.ai.mcp.router.core.discovery.McpServiceDiscovery;
import com.alibaba.cloud.ai.mcp.router.core.discovery.McpServiceDiscoveryFactory;
import com.alibaba.cloud.ai.mcp.router.model.McpServerInfo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeMcpServiceDiscovery
implements McpServiceDiscovery {
    private static final Logger log = LoggerFactory.getLogger(CompositeMcpServiceDiscovery.class);
    private final McpServiceDiscoveryFactory discoveryFactory;
    private final List<String> searchOrder;

    public CompositeMcpServiceDiscovery(McpServiceDiscoveryFactory discoveryFactory, List<String> searchOrder) {
        this.discoveryFactory = discoveryFactory;
        this.searchOrder = searchOrder;
        if (discoveryFactory == null) {
            throw new IllegalArgumentException("McpServiceDiscoveryFactory cannot be null");
        }
        if (searchOrder == null || searchOrder.isEmpty()) {
            throw new IllegalArgumentException("Search order cannot be null or empty");
        }
        log.info("Created composite MCP service discovery with search order: {}", searchOrder);
    }

    @Override
    public McpServerInfo getService(String serviceName) {
        if (serviceName == null || serviceName.trim().isEmpty()) {
            log.warn("Service name is null or empty");
            return null;
        }
        log.debug("Searching for service: {} with order: {}", (Object)serviceName, this.searchOrder);
        for (String discoveryType : this.searchOrder) {
            McpServiceDiscovery discovery = this.discoveryFactory.getDiscovery(discoveryType);
            if (discovery == null) {
                log.debug("No discovery implementation found for type: {}", (Object)discoveryType);
                continue;
            }
            try {
                McpServerInfo serverInfo = discovery.getService(serviceName);
                if (serverInfo != null) {
                    log.info("Found service '{}' using discovery type: {}", (Object)serviceName, (Object)discoveryType);
                    return serverInfo;
                }
                log.debug("Service '{}' not found in discovery type: {}", (Object)serviceName, (Object)discoveryType);
            }
            catch (Exception e) {
                log.error("Error occurred while searching service '{}' in discovery type: {}", new Object[]{serviceName, discoveryType, e});
            }
        }
        log.warn("Service '{}' not found in any registered discovery implementations", (Object)serviceName);
        return null;
    }

    public List<String> getSearchOrder() {
        return List.copyOf(this.searchOrder);
    }

    public McpServiceDiscoveryFactory getDiscoveryFactory() {
        return this.discoveryFactory;
    }
}

