/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.router.core.discovery;

import com.alibaba.cloud.ai.mcp.router.config.DbMcpProperties;
import com.alibaba.cloud.ai.mcp.router.core.discovery.McpServiceDiscovery;
import com.alibaba.cloud.ai.mcp.router.model.McpServerInfo;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DbMcpServiceDiscovery
implements McpServiceDiscovery {
    private static final Logger log = LoggerFactory.getLogger(DbMcpServiceDiscovery.class);
    private final DataSource dataSource;
    private final String querySql;

    public DbMcpServiceDiscovery(DbMcpProperties properties) {
        this.dataSource = this.createDataSource(properties);
        this.querySql = this.buildQuerySql(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public McpServerInfo getService(String serviceName) {
        McpServerInfo serverInfo = null;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement(this.querySql);
            preparedStatement.setString(1, serviceName);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                serverInfo = this.mapResultSetToMcpServerInfo(resultSet);
            }
            this.closeResources(resultSet, preparedStatement, connection);
        }
        catch (SQLException e) {
            try {
                log.error("Failed to get service {} from database", (Object)serviceName, (Object)e);
                this.closeResources(resultSet, preparedStatement, connection);
            }
            catch (Throwable throwable) {
                this.closeResources(resultSet, preparedStatement, connection);
                throw throwable;
            }
        }
        return serverInfo;
    }

    private DataSource createDataSource(DbMcpProperties properties) {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(properties.getUrl());
        config.setUsername(properties.getUsername());
        config.setPassword(properties.getPassword());
        config.setDriverClassName(properties.getDriverClassName());
        config.setMaximumPoolSize(properties.getMaxPoolSize());
        config.setMinimumIdle(properties.getMinIdle());
        config.setConnectionTimeout(properties.getConnectionTimeout());
        return new HikariDataSource(config);
    }

    private String buildQuerySql(DbMcpProperties properties) {
        if (StringUtils.hasText((String)properties.getQuerySql())) {
            return properties.getQuerySql();
        }
        return "SELECT name, description, protocol, version, endpoint, enabled, tags FROM " + properties.getTableName() + " WHERE name = ? AND enabled = true";
    }

    private McpServerInfo mapResultSetToMcpServerInfo(ResultSet resultSet) throws SQLException {
        McpServerInfo serverInfo = new McpServerInfo();
        serverInfo.setName(resultSet.getString("name"));
        serverInfo.setDescription(resultSet.getString("description"));
        serverInfo.setProtocol(resultSet.getString("protocol"));
        serverInfo.setVersion(resultSet.getString("version"));
        serverInfo.setEndpoint(resultSet.getString("endpoint"));
        serverInfo.setEnabled(resultSet.getBoolean("enabled"));
        String tagsStr = resultSet.getString("tags");
        if (StringUtils.hasText((String)tagsStr)) {
            List<String> tags = Arrays.asList(tagsStr.split(","));
            serverInfo.setTags(new ArrayList<String>(tags));
        }
        return serverInfo;
    }

    private void closeResources(ResultSet resultSet, PreparedStatement statement, Connection connection) {
        this.closeQuietly(resultSet, "ResultSet");
        this.closeQuietly(statement, "PreparedStatement");
        this.closeQuietly(connection, "Connection");
    }

    private void closeQuietly(AutoCloseable resource, String name) {
        if (resource != null) {
            try {
                if (resource instanceof Connection) {
                    Connection conn = (Connection)resource;
                    if (!conn.isClosed()) {
                        conn.close();
                    }
                } else {
                    resource.close();
                }
            }
            catch (Exception e) {
                log.error("Failed to close {}", (Object)name, (Object)e);
            }
        }
    }
}

