/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.router.core.discovery;

import com.alibaba.cloud.ai.mcp.router.core.discovery.McpServiceDiscovery;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class McpServiceDiscoveryFactory {
    private static final Logger log = LoggerFactory.getLogger(McpServiceDiscoveryFactory.class);
    private final ConcurrentMap<String, McpServiceDiscovery> discoveryMap = new ConcurrentHashMap<String, McpServiceDiscovery>();

    public void registerDiscovery(String type, McpServiceDiscovery discovery) {
        if (!StringUtils.hasText((String)type)) {
            throw new IllegalArgumentException("Discovery type cannot be null or empty");
        }
        if (discovery == null) {
            throw new IllegalArgumentException("Discovery implementation cannot be null");
        }
        McpServiceDiscovery existing = this.discoveryMap.put(type, discovery);
        if (existing != null) {
            log.warn("Replaced existing MCP service discovery for type: {}", (Object)type);
        } else {
            log.info("Registered MCP service discovery for type: {}", (Object)type);
        }
    }

    public McpServiceDiscovery getDiscovery(String type) {
        return (McpServiceDiscovery)this.discoveryMap.get(type);
    }

    public List<McpServiceDiscovery> getAllDiscoveries() {
        return new ArrayList<McpServiceDiscovery>(this.discoveryMap.values());
    }

    public List<String> getRegisteredTypes() {
        return new ArrayList<String>(this.discoveryMap.keySet());
    }

    public boolean hasDiscovery(String type) {
        return this.discoveryMap.containsKey(type);
    }

    public McpServiceDiscovery removeDiscovery(String type) {
        McpServiceDiscovery removed = (McpServiceDiscovery)this.discoveryMap.remove(type);
        if (removed != null) {
            log.info("Removed MCP service discovery for type: {}", (Object)type);
        }
        return removed;
    }

    public void clear() {
        this.discoveryMap.clear();
        log.info("Cleared all MCP service discovery implementations");
    }

    public int size() {
        return this.discoveryMap.size();
    }
}

