/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.router.core.vectorstore;

import com.alibaba.cloud.ai.mcp.router.core.vectorstore.McpServerVectorStore;
import com.alibaba.cloud.ai.mcp.router.model.McpServerInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.document.Document;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.vectorstore.SearchRequest;
import org.springframework.ai.vectorstore.SimpleVectorStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SimpleMcpServerVectorStore
implements McpServerVectorStore {
    private static final Logger logger = LoggerFactory.getLogger(SimpleMcpServerVectorStore.class);
    private final EmbeddingModel embeddingModel;
    private final SimpleVectorStore vectorStore;

    @Autowired(required=false)
    public SimpleMcpServerVectorStore(EmbeddingModel embeddingModel) {
        this.embeddingModel = embeddingModel;
        if (embeddingModel != null) {
            this.vectorStore = SimpleVectorStore.builder((EmbeddingModel)embeddingModel).build();
            logger.info("SimpleMcpServerVectorStore initialized with EmbeddingModel: {}", (Object)embeddingModel.getClass().getSimpleName());
        } else {
            this.vectorStore = null;
            logger.warn("SimpleMcpServerVectorStore initialized without EmbeddingModel - vector store will be disabled");
        }
    }

    @Override
    public boolean addServer(McpServerInfo serverInfo) {
        if (serverInfo == null || serverInfo.getName() == null) {
            logger.warn("Cannot add server: serverInfo is null or name is null");
            return false;
        }
        if (this.vectorStore == null) {
            logger.warn("Cannot add server '{}': vectorStore is null (no EmbeddingModel available)", (Object)serverInfo.getName());
            return false;
        }
        try {
            Document document = this.convertToDocument(serverInfo);
            logger.debug("Adding server to vector store: {}", (Object)serverInfo.getName());
            this.vectorStore.add(List.of(document));
            logger.info("Successfully added server to vector store: {}", (Object)serverInfo.getName());
            return true;
        }
        catch (Exception e) {
            logger.error("Failed to add server to vector store: {}", (Object)serverInfo.getName(), (Object)e);
            return false;
        }
    }

    @Override
    public boolean removeServer(String serviceName) {
        if (this.vectorStore == null) {
            logger.warn("Cannot remove server '{}': vectorStore is null", (Object)serviceName);
            return false;
        }
        try {
            Document doc;
            SearchRequest searchRequest = SearchRequest.builder().query(serviceName).topK(1).build();
            List documents = this.vectorStore.similaritySearch(searchRequest);
            if (!documents.isEmpty() && serviceName.equals((doc = (Document)documents.get(0)).getMetadata().get("serviceName"))) {
                this.vectorStore.delete(List.of(doc.getId()));
                logger.info("Successfully removed server from vector store: {}", (Object)serviceName);
                return true;
            }
            logger.warn("Server not found in vector store: {}", (Object)serviceName);
            return false;
        }
        catch (Exception e) {
            logger.error("Failed to remove server from vector store: {}", (Object)serviceName, (Object)e);
            return false;
        }
    }

    @Override
    public McpServerInfo getServer(String serviceName) {
        if (this.vectorStore == null) {
            logger.warn("Cannot get server '{}': vectorStore is null", (Object)serviceName);
            return null;
        }
        try {
            Document doc;
            SearchRequest searchRequest = SearchRequest.builder().query(serviceName).topK(1).build();
            List documents = this.vectorStore.similaritySearch(searchRequest);
            if (!documents.isEmpty() && serviceName.equals((doc = (Document)documents.get(0)).getMetadata().get("serviceName"))) {
                return this.convertFromDocument(doc);
            }
            logger.debug("Server not found in vector store: {}", (Object)serviceName);
            return null;
        }
        catch (Exception e) {
            logger.error("Failed to get server from vector store: {}", (Object)serviceName, (Object)e);
            return null;
        }
    }

    @Override
    public List<McpServerInfo> getAllServers() {
        if (this.vectorStore == null) {
            logger.warn("Cannot get all servers: vectorStore is null");
            return new ArrayList<McpServerInfo>();
        }
        try {
            SearchRequest searchRequest = SearchRequest.builder().query("").topK(Integer.MAX_VALUE).build();
            List documents = this.vectorStore.similaritySearch(searchRequest);
            logger.debug("Found {} documents in vector store", (Object)documents.size());
            return documents.stream().map(this::convertFromDocument).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (Exception e) {
            logger.error("Failed to get all servers from vector store", (Throwable)e);
            return new ArrayList<McpServerInfo>();
        }
    }

    @Override
    public List<McpServerInfo> search(String query, int limit) {
        if (this.vectorStore == null) {
            logger.warn("Cannot search servers: vectorStore is null");
            return new ArrayList<McpServerInfo>();
        }
        try {
            List<Document> keywordResults;
            logger.debug("Searching vector store with query: '{}', limit: {}", (Object)query, (Object)limit);
            ArrayList<Document> documents = new ArrayList<Document>();
            if (query != null && !query.trim().isEmpty()) {
                SearchRequest searchRequest = SearchRequest.builder().query(query).topK(limit * 2).build();
                List vectorResults = this.vectorStore.similaritySearch(searchRequest);
                logger.debug("Found {} documents in vector search results", (Object)vectorResults.size());
                documents.addAll(vectorResults);
            }
            if (CollectionUtils.isNotEmpty(keywordResults = this.searchByKeywords(query, limit))) {
                documents.addAll(keywordResults);
                logger.debug("Added {} documents from keyword search", (Object)keywordResults.size());
            }
            if (documents.isEmpty()) {
                logger.debug("No results found, trying to get all servers");
                SearchRequest allRequest = SearchRequest.builder().query("").topK(Integer.MAX_VALUE).build();
                List allDocuments = this.vectorStore.similaritySearch(allRequest);
                documents.addAll(allDocuments);
                logger.debug("Found {} total documents in vector store", (Object)allDocuments.size());
            }
            return documents.stream().filter(doc -> {
                double score = doc.getScore();
                Object keywordScore = doc.getMetadata().get("keywordScore");
                if (keywordScore != null) {
                    return ((Number)keywordScore).doubleValue() > 0.0;
                }
                return score > 0.05;
            }).map(this::convertFromDocument).filter(Objects::nonNull).distinct().sorted((a, b) -> Double.compare(b.getScore(), a.getScore())).limit(limit).collect(Collectors.toList());
        }
        catch (Exception e) {
            logger.error("Failed to search vector store with query: '{}'", (Object)query, (Object)e);
            return new ArrayList<McpServerInfo>();
        }
    }

    private List<Document> searchByKeywords(String query, int limit) {
        try {
            SearchRequest searchRequest = SearchRequest.builder().query("").topK(Integer.MAX_VALUE).build();
            List allDocuments = this.vectorStore.similaritySearch(searchRequest);
            logger.debug("Keyword search: found {} total documents to search in", (Object)allDocuments.size());
            if (query == null || query.trim().isEmpty()) {
                return allDocuments.stream().map(doc -> {
                    HashMap<String, Double> newMetadata = new HashMap<String, Double>(doc.getMetadata());
                    newMetadata.put("keywordScore", 0.5);
                    return new Document(doc.getId(), doc.getText(), newMetadata);
                }).limit(limit).collect(Collectors.toList());
            }
            String lowerQuery = query.toLowerCase().trim();
            return allDocuments.stream().filter(doc -> {
                String serviceName = (String)doc.getMetadata().get("serviceName");
                if (serviceName != null && serviceName.toLowerCase().contains(lowerQuery)) {
                    logger.debug("Keyword match found in serviceName: {}", (Object)serviceName);
                    return true;
                }
                String description = (String)doc.getMetadata().get("description");
                if (description != null && description.toLowerCase().contains(lowerQuery)) {
                    logger.debug("Keyword match found in description: {}", (Object)description);
                    return true;
                }
                List tags = (List)doc.getMetadata().get("tags");
                if (tags != null && tags.stream().anyMatch(tag -> tag.toLowerCase().contains(lowerQuery))) {
                    logger.debug("Keyword match found in tags: {}", (Object)tags);
                    return true;
                }
                String protocol = (String)doc.getMetadata().get("protocol");
                if (protocol != null && protocol.toLowerCase().contains(lowerQuery)) {
                    logger.debug("Keyword match found in protocol: {}", (Object)protocol);
                    return true;
                }
                String version = (String)doc.getMetadata().get("version");
                if (version != null && version.toLowerCase().contains(lowerQuery)) {
                    logger.debug("Keyword match found in version: {}", (Object)version);
                    return true;
                }
                String endpoint = (String)doc.getMetadata().get("endpoint");
                if (endpoint != null && endpoint.toLowerCase().contains(lowerQuery)) {
                    logger.debug("Keyword match found in endpoint: {}", (Object)endpoint);
                    return true;
                }
                return false;
            }).map(doc -> {
                HashMap<String, Double> newMetadata = new HashMap<String, Double>(doc.getMetadata());
                newMetadata.put("keywordScore", 0.5);
                return new Document(doc.getId(), doc.getText(), newMetadata);
            }).limit(limit).collect(Collectors.toList());
        }
        catch (Exception e) {
            logger.error("Failed to search by keywords with query: '{}'", (Object)query, (Object)e);
            return new ArrayList<Document>();
        }
    }

    @Override
    public int size() {
        if (this.vectorStore == null) {
            return 0;
        }
        try {
            SearchRequest searchRequest = SearchRequest.builder().query("").topK(Integer.MAX_VALUE).build();
            List documents = this.vectorStore.similaritySearch(searchRequest);
            logger.debug("Vector store size: {}", (Object)documents.size());
            return documents.size();
        }
        catch (Exception e) {
            logger.error("Failed to get vector store size", (Throwable)e);
            return 0;
        }
    }

    @Override
    public void clear() {
        if (this.vectorStore == null) {
            logger.warn("Cannot clear vector store: vectorStore is null");
            return;
        }
        try {
            SearchRequest searchRequest = SearchRequest.builder().query("").topK(Integer.MAX_VALUE).build();
            List documents = this.vectorStore.similaritySearch(searchRequest);
            List ids = documents.stream().map(Document::getId).collect(Collectors.toList());
            if (!ids.isEmpty()) {
                this.vectorStore.delete(ids);
                logger.info("Cleared {} documents from vector store", (Object)ids.size());
            }
        }
        catch (Exception e) {
            logger.error("Failed to clear vector store", (Throwable)e);
        }
    }

    private Document convertToDocument(McpServerInfo serverInfo) {
        StringBuilder textBuilder = new StringBuilder();
        textBuilder.append(serverInfo.getName()).append(" ");
        if (serverInfo.getDescription() != null && !serverInfo.getDescription().trim().isEmpty()) {
            textBuilder.append(serverInfo.getDescription()).append(" ");
            textBuilder.append(serverInfo.getDescription()).append(" ");
        }
        if (serverInfo.getProtocol() != null && !serverInfo.getProtocol().trim().isEmpty()) {
            textBuilder.append(serverInfo.getProtocol()).append(" ");
        }
        if (serverInfo.getVersion() != null && !serverInfo.getVersion().trim().isEmpty()) {
            textBuilder.append(serverInfo.getVersion()).append(" ");
        }
        if (serverInfo.getEndpoint() != null && !serverInfo.getEndpoint().trim().isEmpty()) {
            textBuilder.append(serverInfo.getEndpoint()).append(" ");
        }
        if (serverInfo.getTags() != null && !serverInfo.getTags().isEmpty()) {
            textBuilder.append(String.join((CharSequence)" ", serverInfo.getTags())).append(" ");
        }
        Map<String, String> metadata = Map.of("serviceName", serverInfo.getName(), "description", Optional.ofNullable(serverInfo.getDescription()).orElse(""), "protocol", Optional.ofNullable(serverInfo.getProtocol()).orElse(""), "version", Optional.ofNullable(serverInfo.getVersion()).orElse(""), "endpoint", Optional.ofNullable(serverInfo.getEndpoint()).orElse(""), "enabled", Optional.ofNullable(serverInfo.getEnabled()).orElse(true), "tags", Optional.ofNullable(serverInfo.getTags()).orElse(List.of()), "vectorType", "mcp_service");
        return new Document(serverInfo.getName(), textBuilder.toString().trim(), metadata);
    }

    private McpServerInfo convertFromDocument(Document document) {
        try {
            String serviceName = (String)document.getMetadata().get("serviceName");
            String description = (String)document.getMetadata().get("description");
            String protocol = (String)document.getMetadata().get("protocol");
            String version = (String)document.getMetadata().get("version");
            String endpoint = (String)document.getMetadata().get("endpoint");
            Boolean enabled = (Boolean)document.getMetadata().get("enabled");
            List tags = (List)document.getMetadata().get("tags");
            McpServerInfo serverInfo = new McpServerInfo(serviceName, description, protocol, version, endpoint, enabled, tags);
            Object keywordScore = document.getMetadata().get("keywordScore");
            if (keywordScore != null) {
                serverInfo.setScore(((Number)keywordScore).doubleValue());
            } else {
                serverInfo.setScore(document.getScore());
            }
            return serverInfo;
        }
        catch (Exception e) {
            logger.error("Failed to convert document to McpServerInfo", (Throwable)e);
            return null;
        }
    }

    public void debugVectorStore() {
        if (this.vectorStore == null) {
            logger.warn("Vector store is null - no EmbeddingModel available");
            return;
        }
        try {
            SearchRequest searchRequest = SearchRequest.builder().query("").topK(Integer.MAX_VALUE).build();
            List allDocuments = this.vectorStore.similaritySearch(searchRequest);
            logger.info("=== Vector Store Debug Information ===");
            logger.info("Total documents in vector store: {}", (Object)allDocuments.size());
            for (int i = 0; i < allDocuments.size(); ++i) {
                Document doc = (Document)allDocuments.get(i);
                logger.info("Document {}: ID={}, Score={}", new Object[]{i + 1, doc.getId(), doc.getScore()});
                logger.info("  ServiceName: {}", doc.getMetadata().get("serviceName"));
                logger.info("  Description: {}", doc.getMetadata().get("description"));
                logger.info("  Protocol: {}", doc.getMetadata().get("protocol"));
                logger.info("  Version: {}", doc.getMetadata().get("version"));
                logger.info("  Endpoint: {}", doc.getMetadata().get("endpoint"));
                logger.info("  Tags: {}", doc.getMetadata().get("tags"));
                logger.info("  Text content: {}", (Object)(doc.getText().substring(0, Math.min(100, doc.getText().length())) + "..."));
            }
            logger.info("=== End Debug Information ===");
        }
        catch (Exception e) {
            logger.error("Failed to debug vector store", (Throwable)e);
        }
    }

    public void debugSearch(String query, int limit) {
        logger.info("=== Search Debug for query: '{}' ===", (Object)query);
        if (this.vectorStore == null) {
            logger.warn("Vector store is null");
            return;
        }
        try {
            SearchRequest vectorRequest = SearchRequest.builder().query(query).topK(limit * 2).build();
            List vectorResults = this.vectorStore.similaritySearch(vectorRequest);
            logger.info("Vector search results: {}", (Object)vectorResults.size());
            for (Object doc : vectorResults) {
                logger.info("  Vector result: {} (score: {})", doc.getMetadata().get("serviceName"), (Object)doc.getScore());
            }
            List<Document> keywordResults = this.searchByKeywords(query, limit);
            logger.info("Keyword search results: {}", (Object)keywordResults.size());
            for (Document doc : keywordResults) {
                logger.info("  Keyword result: {} (score: {})", doc.getMetadata().get("serviceName"), (Object)doc.getScore());
            }
            List<McpServerInfo> fullResults = this.search(query, limit);
            logger.info("Full search results: {}", (Object)fullResults.size());
            for (McpServerInfo info : fullResults) {
                logger.info("  Full result: {} (score: {})", (Object)info.getName(), (Object)info.getScore());
            }
            logger.info("=== End Search Debug ===");
        }
        catch (Exception e) {
            logger.error("Failed to debug search", (Throwable)e);
        }
    }
}

