/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.router.model.response;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class McpDebugResponse {
    @JsonProperty(value="success")
    private boolean success;
    @JsonProperty(value="error_message")
    private String errorMessage;
    @JsonProperty(value="service_name")
    private String serviceName;
    @JsonProperty(value="debug_timestamp")
    private Long debugTimestamp = System.currentTimeMillis();
    @JsonProperty(value="service_status")
    private McpServiceStatus serviceStatus;
    @JsonProperty(value="connection_diagnosis")
    private McpConnectionDiagnosis connectionDiagnosis;
    @JsonProperty(value="troubleshooting_suggestions")
    private List<String> troubleshootingSuggestions;
    @JsonProperty(value="system_info")
    private Map<String, Object> systemInfo;

    public static McpDebugResponse success(String serviceName, McpServiceStatus serviceStatus, McpConnectionDiagnosis connectionDiagnosis, List<String> suggestions) {
        McpDebugResponse response = new McpDebugResponse();
        response.success = true;
        response.serviceName = serviceName;
        response.serviceStatus = serviceStatus;
        response.connectionDiagnosis = connectionDiagnosis;
        response.troubleshootingSuggestions = suggestions;
        return response;
    }

    public static McpDebugResponse error(String serviceName, String errorMessage) {
        McpDebugResponse response = new McpDebugResponse();
        response.success = false;
        response.serviceName = serviceName;
        response.errorMessage = errorMessage;
        return response;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public Long getDebugTimestamp() {
        return this.debugTimestamp;
    }

    public void setDebugTimestamp(Long debugTimestamp) {
        this.debugTimestamp = debugTimestamp;
    }

    public McpServiceStatus getServiceStatus() {
        return this.serviceStatus;
    }

    public void setServiceStatus(McpServiceStatus serviceStatus) {
        this.serviceStatus = serviceStatus;
    }

    public McpConnectionDiagnosis getConnectionDiagnosis() {
        return this.connectionDiagnosis;
    }

    public void setConnectionDiagnosis(McpConnectionDiagnosis connectionDiagnosis) {
        this.connectionDiagnosis = connectionDiagnosis;
    }

    public List<String> getTroubleshootingSuggestions() {
        return this.troubleshootingSuggestions;
    }

    public void setTroubleshootingSuggestions(List<String> troubleshootingSuggestions) {
        this.troubleshootingSuggestions = troubleshootingSuggestions;
    }

    public Map<String, Object> getSystemInfo() {
        return this.systemInfo;
    }

    public void setSystemInfo(Map<String, Object> systemInfo) {
        this.systemInfo = systemInfo;
    }

    public String toString() {
        return "McpDebugResponse{success=" + this.success + ", errorMessage='" + this.errorMessage + "', serviceName='" + this.serviceName + "', debugTimestamp=" + this.debugTimestamp + ", serviceStatus=" + this.serviceStatus + ", connectionDiagnosis=" + this.connectionDiagnosis + ", troubleshootingSuggestions=" + this.troubleshootingSuggestions + ", systemInfo=" + this.systemInfo + "}";
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class McpServiceStatus {
        @JsonProperty(value="found_in_vector_store")
        private boolean foundInVectorStore;
        @JsonProperty(value="found_in_nacos")
        private boolean foundInNacos;
        @JsonProperty(value="remote_config_valid")
        private boolean remoteConfigValid;
        @JsonProperty(value="service_ref_valid")
        private boolean serviceRefValid;
        @JsonProperty(value="endpoint_available")
        private boolean endpointAvailable;
        @JsonProperty(value="connection_cached")
        private boolean connectionCached;
        @JsonProperty(value="service_info")
        private Map<String, String> serviceInfo;

        public boolean isFoundInVectorStore() {
            return this.foundInVectorStore;
        }

        public void setFoundInVectorStore(boolean foundInVectorStore) {
            this.foundInVectorStore = foundInVectorStore;
        }

        public boolean isFoundInNacos() {
            return this.foundInNacos;
        }

        public void setFoundInNacos(boolean foundInNacos) {
            this.foundInNacos = foundInNacos;
        }

        public boolean isRemoteConfigValid() {
            return this.remoteConfigValid;
        }

        public void setRemoteConfigValid(boolean remoteConfigValid) {
            this.remoteConfigValid = remoteConfigValid;
        }

        public boolean isServiceRefValid() {
            return this.serviceRefValid;
        }

        public void setServiceRefValid(boolean serviceRefValid) {
            this.serviceRefValid = serviceRefValid;
        }

        public boolean isEndpointAvailable() {
            return this.endpointAvailable;
        }

        public void setEndpointAvailable(boolean endpointAvailable) {
            this.endpointAvailable = endpointAvailable;
        }

        public boolean isConnectionCached() {
            return this.connectionCached;
        }

        public void setConnectionCached(boolean connectionCached) {
            this.connectionCached = connectionCached;
        }

        public Map<String, String> getServiceInfo() {
            return this.serviceInfo;
        }

        public void setServiceInfo(Map<String, String> serviceInfo) {
            this.serviceInfo = serviceInfo;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class McpConnectionDiagnosis {
        @JsonProperty(value="full_url")
        private String fullUrl;
        @JsonProperty(value="base_url_reachable")
        private boolean baseUrlReachable;
        @JsonProperty(value="endpoint_reachable")
        private boolean endpointReachable;
        @JsonProperty(value="http_status_code")
        private Integer httpStatusCode;
        @JsonProperty(value="response_time_ms")
        private Long responseTimeMs;
        @JsonProperty(value="diagnosis_details")
        private List<String> diagnosisDetails;
        @JsonProperty(value="network_error")
        private String networkError;

        public String getFullUrl() {
            return this.fullUrl;
        }

        public void setFullUrl(String fullUrl) {
            this.fullUrl = fullUrl;
        }

        public boolean isBaseUrlReachable() {
            return this.baseUrlReachable;
        }

        public void setBaseUrlReachable(boolean baseUrlReachable) {
            this.baseUrlReachable = baseUrlReachable;
        }

        public boolean isEndpointReachable() {
            return this.endpointReachable;
        }

        public void setEndpointReachable(boolean endpointReachable) {
            this.endpointReachable = endpointReachable;
        }

        public Integer getHttpStatusCode() {
            return this.httpStatusCode;
        }

        public void setHttpStatusCode(Integer httpStatusCode) {
            this.httpStatusCode = httpStatusCode;
        }

        public Long getResponseTimeMs() {
            return this.responseTimeMs;
        }

        public void setResponseTimeMs(Long responseTimeMs) {
            this.responseTimeMs = responseTimeMs;
        }

        public List<String> getDiagnosisDetails() {
            return this.diagnosisDetails;
        }

        public void setDiagnosisDetails(List<String> diagnosisDetails) {
            this.diagnosisDetails = diagnosisDetails;
        }

        public String getNetworkError() {
            return this.networkError;
        }

        public void setNetworkError(String networkError) {
            this.networkError = networkError;
        }
    }
}

