/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.router.model.response;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class McpServerAddResponse {
    @JsonProperty(value="success")
    private boolean success;
    @JsonProperty(value="error_message")
    private String errorMessage;
    @JsonProperty(value="service_name")
    private String serviceName;
    @JsonProperty(value="service_info")
    private McpServerServiceInfo serviceInfo;
    @JsonProperty(value="connection_status")
    private McpConnectionStatus connectionStatus;
    @JsonProperty(value="available_tools")
    private List<McpToolInfo> availableTools;
    @JsonProperty(value="usage_guide")
    private McpUsageGuide usageGuide;

    public static McpServerAddResponse success(String serviceName, McpServerServiceInfo serviceInfo, McpConnectionStatus connectionStatus, List<McpToolInfo> tools, McpUsageGuide usageGuide) {
        McpServerAddResponse response = new McpServerAddResponse();
        response.success = true;
        response.serviceName = serviceName;
        response.serviceInfo = serviceInfo;
        response.connectionStatus = connectionStatus;
        response.availableTools = tools;
        response.usageGuide = usageGuide;
        return response;
    }

    public static McpServerAddResponse error(String serviceName, String errorMessage) {
        McpServerAddResponse response = new McpServerAddResponse();
        response.success = false;
        response.serviceName = serviceName;
        response.errorMessage = errorMessage;
        return response;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public McpServerServiceInfo getServiceInfo() {
        return this.serviceInfo;
    }

    public void setServiceInfo(McpServerServiceInfo serviceInfo) {
        this.serviceInfo = serviceInfo;
    }

    public McpConnectionStatus getConnectionStatus() {
        return this.connectionStatus;
    }

    public void setConnectionStatus(McpConnectionStatus connectionStatus) {
        this.connectionStatus = connectionStatus;
    }

    public List<McpToolInfo> getAvailableTools() {
        return this.availableTools;
    }

    public void setAvailableTools(List<McpToolInfo> availableTools) {
        this.availableTools = availableTools;
    }

    public McpUsageGuide getUsageGuide() {
        return this.usageGuide;
    }

    public void setUsageGuide(McpUsageGuide usageGuide) {
        this.usageGuide = usageGuide;
    }

    public String toString() {
        return "McpServerAddResponse{success=" + this.success + ", errorMessage='" + this.errorMessage + "', serviceName='" + this.serviceName + "', serviceInfo=" + this.serviceInfo + ", connectionStatus=" + this.connectionStatus + ", availableTools=" + this.availableTools + ", usageGuide=" + this.usageGuide + "}";
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class McpServerServiceInfo {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="protocol")
        private String protocol;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="endpoint")
        private String endpoint;
        @JsonProperty(value="tags")
        private List<String> tags;

        public McpServerServiceInfo() {
        }

        public McpServerServiceInfo(String name, String description, String protocol, String version, String endpoint, List<String> tags) {
            this.name = name;
            this.description = description;
            this.protocol = protocol;
            this.version = version;
            this.endpoint = endpoint;
            this.tags = tags;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public List<String> getTags() {
            return this.tags;
        }

        public void setTags(List<String> tags) {
            this.tags = tags;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class McpConnectionStatus {
        @JsonProperty(value="connected")
        private boolean connected;
        @JsonProperty(value="connection_url")
        private String connectionUrl;
        @JsonProperty(value="connected_at")
        private Long connectedAt;
        @JsonProperty(value="message")
        private String message;

        public McpConnectionStatus() {
        }

        public McpConnectionStatus(boolean connected, String connectionUrl, String message) {
            this.connected = connected;
            this.connectionUrl = connectionUrl;
            this.message = message;
            this.connectedAt = connected ? Long.valueOf(System.currentTimeMillis()) : null;
        }

        public boolean isConnected() {
            return this.connected;
        }

        public void setConnected(boolean connected) {
            this.connected = connected;
        }

        public String getConnectionUrl() {
            return this.connectionUrl;
        }

        public void setConnectionUrl(String connectionUrl) {
            this.connectionUrl = connectionUrl;
        }

        public Long getConnectedAt() {
            return this.connectedAt;
        }

        public void setConnectedAt(Long connectedAt) {
            this.connectedAt = connectedAt;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class McpUsageGuide {
        @JsonProperty(value="how_to_use_tools")
        private String howToUseTools;
        @JsonProperty(value="example_call")
        private String exampleCall;
        @JsonProperty(value="available_operations")
        private List<String> availableOperations;

        public McpUsageGuide() {
        }

        public McpUsageGuide(String howToUseTools, String exampleCall, List<String> availableOperations) {
            this.howToUseTools = howToUseTools;
            this.exampleCall = exampleCall;
            this.availableOperations = availableOperations;
        }

        public String getHowToUseTools() {
            return this.howToUseTools;
        }

        public void setHowToUseTools(String howToUseTools) {
            this.howToUseTools = howToUseTools;
        }

        public String getExampleCall() {
            return this.exampleCall;
        }

        public void setExampleCall(String exampleCall) {
            this.exampleCall = exampleCall;
        }

        public List<String> getAvailableOperations() {
            return this.availableOperations;
        }

        public void setAvailableOperations(List<String> availableOperations) {
            this.availableOperations = availableOperations;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class McpToolParameter {
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="required")
        private boolean required;
        @JsonProperty(value="default_value")
        private Object defaultValue;

        public McpToolParameter() {
        }

        public McpToolParameter(String type, String description, boolean required, Object defaultValue) {
            this.type = type;
            this.description = description;
            this.required = required;
            this.defaultValue = defaultValue;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public boolean isRequired() {
            return this.required;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class McpToolInfo {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="parameters")
        private Map<String, McpToolParameter> parameters;
        @JsonProperty(value="enabled")
        private boolean enabled;

        public McpToolInfo() {
        }

        public McpToolInfo(String name, String description, Map<String, McpToolParameter> parameters, boolean enabled) {
            this.name = name;
            this.description = description;
            this.parameters = parameters;
            this.enabled = enabled;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Map<String, McpToolParameter> getParameters() {
            return this.parameters;
        }

        public void setParameters(Map<String, McpToolParameter> parameters) {
            this.parameters = parameters;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

