/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.router.model.response;

import com.alibaba.cloud.ai.mcp.router.model.McpServerInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class McpServerSearchResponse {
    @JsonProperty(value="success")
    private boolean success;
    @JsonProperty(value="error_message")
    private String errorMessage;
    @JsonProperty(value="search_query")
    private String searchQuery;
    @JsonProperty(value="total_count")
    private int totalCount;
    @JsonProperty(value="servers")
    private List<McpServerSearchResult> servers;
    @JsonProperty(value="suggestions")
    private List<String> suggestions;

    public McpServerSearchResponse() {
    }

    public McpServerSearchResponse(boolean success, String searchQuery, List<McpServerSearchResult> servers) {
        this.success = success;
        this.searchQuery = searchQuery;
        this.servers = servers;
        this.totalCount = servers != null ? servers.size() : 0;
    }

    public static McpServerSearchResponse success(String searchQuery, List<McpServerSearchResult> servers) {
        return new McpServerSearchResponse(true, searchQuery, servers);
    }

    public static McpServerSearchResponse error(String searchQuery, String errorMessage) {
        McpServerSearchResponse response = new McpServerSearchResponse();
        response.success = false;
        response.searchQuery = searchQuery;
        response.errorMessage = errorMessage;
        response.totalCount = 0;
        return response;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getSearchQuery() {
        return this.searchQuery;
    }

    public void setSearchQuery(String searchQuery) {
        this.searchQuery = searchQuery;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public List<McpServerSearchResult> getServers() {
        return this.servers;
    }

    public void setServers(List<McpServerSearchResult> servers) {
        this.servers = servers;
        this.totalCount = servers != null ? servers.size() : 0;
    }

    public List<String> getSuggestions() {
        return this.suggestions;
    }

    public void setSuggestions(List<String> suggestions) {
        this.suggestions = suggestions;
    }

    public String toString() {
        return "McpServerSearchResponse{success=" + this.success + ", errorMessage='" + this.errorMessage + "', searchQuery='" + this.searchQuery + "', totalCount=" + this.totalCount + ", servers=" + this.servers + ", suggestions=" + this.suggestions + "}";
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class McpServerSearchResult {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="protocol")
        private String protocol;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="endpoint")
        private String endpoint;
        @JsonProperty(value="enabled")
        private Boolean enabled;
        @JsonProperty(value="tags")
        private List<String> tags;
        @JsonProperty(value="similarity_score")
        private double similarityScore;

        public McpServerSearchResult() {
        }

        public McpServerSearchResult(McpServerInfo serverInfo) {
            this.name = serverInfo.getName();
            this.description = serverInfo.getDescription();
            this.protocol = serverInfo.getProtocol();
            this.version = serverInfo.getVersion();
            this.endpoint = serverInfo.getEndpoint();
            this.enabled = serverInfo.getEnabled();
            this.tags = serverInfo.getTags();
            this.similarityScore = serverInfo.getScore();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public List<String> getTags() {
            return this.tags;
        }

        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        public double getSimilarityScore() {
            return this.similarityScore;
        }

        public void setSimilarityScore(double similarityScore) {
            this.similarityScore = similarityScore;
        }
    }
}

