/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.router.model.response;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class McpToolExecutionResponse {
    @JsonProperty(value="success")
    private boolean success;
    @JsonProperty(value="error_message")
    private String errorMessage;
    @JsonProperty(value="service_name")
    private String serviceName;
    @JsonProperty(value="tool_name")
    private String toolName;
    @JsonProperty(value="execution_parameters")
    private Map<String, Object> executionParameters;
    @JsonProperty(value="result")
    private McpToolExecutionResult result;
    @JsonProperty(value="execution_meta")
    private McpExecutionMeta executionMeta;

    public static McpToolExecutionResponse success(String serviceName, String toolName, Map<String, Object> parameters, McpToolExecutionResult result, McpExecutionMeta meta) {
        McpToolExecutionResponse response = new McpToolExecutionResponse();
        response.success = true;
        response.serviceName = serviceName;
        response.toolName = toolName;
        response.executionParameters = parameters;
        response.result = result;
        response.executionMeta = meta;
        return response;
    }

    public static McpToolExecutionResponse error(String serviceName, String toolName, Map<String, Object> parameters, String errorMessage) {
        McpToolExecutionResponse response = new McpToolExecutionResponse();
        response.success = false;
        response.serviceName = serviceName;
        response.toolName = toolName;
        response.executionParameters = parameters;
        response.errorMessage = errorMessage;
        return response;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getToolName() {
        return this.toolName;
    }

    public void setToolName(String toolName) {
        this.toolName = toolName;
    }

    public Map<String, Object> getExecutionParameters() {
        return this.executionParameters;
    }

    public void setExecutionParameters(Map<String, Object> executionParameters) {
        this.executionParameters = executionParameters;
    }

    public McpToolExecutionResult getResult() {
        return this.result;
    }

    public void setResult(McpToolExecutionResult result) {
        this.result = result;
    }

    public McpExecutionMeta getExecutionMeta() {
        return this.executionMeta;
    }

    public void setExecutionMeta(McpExecutionMeta executionMeta) {
        this.executionMeta = executionMeta;
    }

    public String toString() {
        return "McpToolExecutionResponse{success=" + this.success + ", errorMessage='" + this.errorMessage + "', serviceName='" + this.serviceName + "', toolName='" + this.toolName + "', executionParameters=" + this.executionParameters + ", result=" + this.result + ", executionMeta=" + this.executionMeta + "}";
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class McpToolExecutionResult {
        @JsonProperty(value="content_type")
        private String contentType;
        @JsonProperty(value="content")
        private Object content;
        @JsonProperty(value="raw_response")
        private String rawResponse;
        @JsonProperty(value="content_size")
        private Long contentSize;

        public McpToolExecutionResult() {
        }

        public McpToolExecutionResult(String contentType, Object content, String rawResponse) {
            this.contentType = contentType;
            this.content = content;
            this.rawResponse = rawResponse;
            this.contentSize = rawResponse != null ? Long.valueOf(rawResponse.length()) : null;
        }

        public static McpToolExecutionResult text(String content) {
            return new McpToolExecutionResult("text", content, content);
        }

        public static McpToolExecutionResult json(Object content, String rawResponse) {
            return new McpToolExecutionResult("json", content, rawResponse);
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public Object getContent() {
            return this.content;
        }

        public void setContent(Object content) {
            this.content = content;
        }

        public String getRawResponse() {
            return this.rawResponse;
        }

        public void setRawResponse(String rawResponse) {
            this.rawResponse = rawResponse;
            this.contentSize = rawResponse != null ? Long.valueOf(rawResponse.length()) : null;
        }

        public Long getContentSize() {
            return this.contentSize;
        }

        public void setContentSize(Long contentSize) {
            this.contentSize = contentSize;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class McpExecutionMeta {
        @JsonProperty(value="execution_start")
        private Long executionStart;
        @JsonProperty(value="execution_end")
        private Long executionEnd;
        @JsonProperty(value="execution_duration_ms")
        private Long executionDurationMs;
        @JsonProperty(value="protocol_used")
        private String protocolUsed;
        @JsonProperty(value="connection_url")
        private String connectionUrl;
        @JsonProperty(value="retry_count")
        private Integer retryCount;

        public McpExecutionMeta() {
        }

        public McpExecutionMeta(Long executionStart, Long executionEnd, String protocolUsed, String connectionUrl) {
            this.executionStart = executionStart;
            this.executionEnd = executionEnd;
            this.executionDurationMs = executionEnd != null && executionStart != null ? Long.valueOf(executionEnd - executionStart) : null;
            this.protocolUsed = protocolUsed;
            this.connectionUrl = connectionUrl;
            this.retryCount = 0;
        }

        public static McpExecutionMeta start(String protocolUsed, String connectionUrl) {
            return new McpExecutionMeta(System.currentTimeMillis(), null, protocolUsed, connectionUrl);
        }

        public void complete() {
            this.executionEnd = System.currentTimeMillis();
            if (this.executionStart != null) {
                this.executionDurationMs = this.executionEnd - this.executionStart;
            }
        }

        public Long getExecutionStart() {
            return this.executionStart;
        }

        public void setExecutionStart(Long executionStart) {
            this.executionStart = executionStart;
        }

        public Long getExecutionEnd() {
            return this.executionEnd;
        }

        public void setExecutionEnd(Long executionEnd) {
            this.executionEnd = executionEnd;
        }

        public Long getExecutionDurationMs() {
            return this.executionDurationMs;
        }

        public void setExecutionDurationMs(Long executionDurationMs) {
            this.executionDurationMs = executionDurationMs;
        }

        public String getProtocolUsed() {
            return this.protocolUsed;
        }

        public void setProtocolUsed(String protocolUsed) {
            this.protocolUsed = protocolUsed;
        }

        public String getConnectionUrl() {
            return this.connectionUrl;
        }

        public void setConnectionUrl(String connectionUrl) {
            this.connectionUrl = connectionUrl;
        }

        public Integer getRetryCount() {
            return this.retryCount;
        }

        public void setRetryCount(Integer retryCount) {
            this.retryCount = retryCount;
        }
    }
}

