/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.router.nacos;

import com.alibaba.cloud.ai.mcp.nacos.service.NacosMcpOperationService;
import com.alibaba.cloud.ai.mcp.router.core.discovery.McpServiceDiscovery;
import com.alibaba.cloud.ai.mcp.router.model.McpServerInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerDetailInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServiceRef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class NacosMcpServiceDiscovery
implements McpServiceDiscovery {
    private final NacosMcpOperationService nacosMcpOperationService;
    private final Map<String, McpServerInfo> serviceCache = new ConcurrentHashMap<String, McpServerInfo>();
    private final Map<String, String> serviceVersionCache = new ConcurrentHashMap<String, String>();

    public NacosMcpServiceDiscovery(NacosMcpOperationService nacosMcpOperationService) {
        this.nacosMcpOperationService = nacosMcpOperationService;
    }

    public McpServerInfo fetchAndCacheService(String serviceName) {
        try {
            boolean changed;
            McpServerDetailInfo detail = this.nacosMcpOperationService.getServerDetail(serviceName);
            if (detail == null) {
                return null;
            }
            String version = detail.getVersionDetail() != null ? detail.getVersionDetail().getVersion() : "";
            String cacheVersion = this.serviceVersionCache.get(serviceName);
            boolean bl = changed = cacheVersion == null || !cacheVersion.equals(version);
            if (changed) {
                String name = detail.getName();
                String description = detail.getDescription();
                String protocol = detail.getProtocol();
                String endpoint = null;
                if (detail.getRemoteServerConfig() != null && detail.getRemoteServerConfig().getServiceRef() != null) {
                    McpServiceRef ref = detail.getRemoteServerConfig().getServiceRef();
                    String exportPath = detail.getRemoteServerConfig().getExportPath();
                    endpoint = ref.getServiceName() + "@" + ref.getGroupName() + (exportPath != null ? exportPath : "");
                }
                ArrayList<String> tags = new ArrayList<String>();
                if (description != null && !description.isEmpty()) {
                    tags.addAll(Arrays.asList(description.split("[ ,;|]")));
                }
                McpServerInfo info = new McpServerInfo(name, description, protocol, version, endpoint, true, tags);
                this.serviceCache.put(serviceName, info);
                this.serviceVersionCache.put(serviceName, version);
                return info;
            }
            return this.serviceCache.get(serviceName);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public McpServerInfo getService(String serviceName) {
        return this.fetchAndCacheService(serviceName);
    }
}

