/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.router.service;

import com.alibaba.cloud.ai.mcp.nacos.service.NacosMcpOperationService;
import com.alibaba.nacos.api.ai.model.mcp.McpEndpointInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerDetailInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerRemoteServiceConfig;
import com.alibaba.nacos.api.ai.model.mcp.McpServiceRef;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.client.McpClient;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.client.transport.HttpClientSseClientTransport;
import io.modelcontextprotocol.spec.McpClientTransport;
import io.modelcontextprotocol.spec.McpSchema;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class McpProxyService {
    private static final Logger logger = LoggerFactory.getLogger(McpProxyService.class);
    private final NacosMcpOperationService nacosMcpOperationService;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Map<String, McpSyncClient> clientConnections = new ConcurrentHashMap<String, McpSyncClient>();

    public McpProxyService(NacosMcpOperationService nacosMcpOperationService) {
        this.nacosMcpOperationService = nacosMcpOperationService;
    }

    public String callTool(String serviceName, String toolName, Map<String, Object> args) {
        try {
            McpServerDetailInfo serverDetail = this.nacosMcpOperationService.getServerDetail(serviceName);
            if (serverDetail == null) {
                throw new RuntimeException("Service not found: " + serviceName);
            }
            String protocol = serverDetail.getProtocol();
            McpServerRemoteServiceConfig remoteConfig = serverDetail.getRemoteServerConfig();
            HashMap<String, Object> enrichedArgs = new HashMap<String, Object>(args);
            enrichedArgs.put("toolName", toolName);
            switch (protocol.toLowerCase()) {
                case "http": 
                case "https": {
                    return this.handleHttpHttpsProtocol(enrichedArgs, remoteConfig, protocol);
                }
                case "mcp-sse": 
                case "mcp-streamable": {
                    return this.handleMcpStreamProtocol(enrichedArgs, remoteConfig, protocol);
                }
            }
            throw new RuntimeException("Unsupported protocol: " + protocol);
        }
        catch (Exception e) {
            logger.error("Failed to call tool: {} on service: {}", new Object[]{toolName, serviceName, e});
            return "Error: " + e.getMessage();
        }
    }

    private String handleHttpHttpsProtocol(Map<String, Object> args, McpServerRemoteServiceConfig remoteServerConfig, String protocol) throws NacosException {
        McpServiceRef serviceRef = remoteServerConfig.getServiceRef();
        if (serviceRef == null) {
            throw new RuntimeException("Service reference is null");
        }
        McpEndpointInfo mcpEndpointInfo = this.nacosMcpOperationService.selectEndpoint(serviceRef);
        if (mcpEndpointInfo == null) {
            throw new RuntimeException("No available endpoint found for service: " + serviceRef.getServiceName());
        }
        logger.info("HTTP/HTTPS Tool callback instance: {}", (Object)JacksonUtils.toJson((Object)mcpEndpointInfo));
        String baseUrl = protocol + "://" + mcpEndpointInfo.getAddress() + ":" + mcpEndpointInfo.getPort();
        return String.format("HTTP/HTTPS protocol response - BaseUrl: %s, Args: %s", baseUrl, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String handleMcpStreamProtocol(Map<String, Object> args, McpServerRemoteServiceConfig remoteServerConfig, String protocol) throws NacosException {
        McpServiceRef serviceRef = remoteServerConfig.getServiceRef();
        if (serviceRef == null) {
            throw new RuntimeException("Service reference is null");
        }
        McpEndpointInfo mcpEndpointInfo = this.nacosMcpOperationService.selectEndpoint(serviceRef);
        if (mcpEndpointInfo == null) {
            throw new RuntimeException("No available endpoint found for service: " + serviceRef.getServiceName());
        }
        logger.info("MCP Stream Tool callback instance: {}", (Object)JacksonUtils.toJson((Object)mcpEndpointInfo));
        String exportPath = remoteServerConfig.getExportPath();
        String baseUrl = "http://" + mcpEndpointInfo.getAddress() + ":" + mcpEndpointInfo.getPort();
        String sseEndpoint = exportPath != null && !exportPath.isEmpty() ? exportPath : "/sse";
        logger.info("Processing {} protocol with args: {} and baseUrl: {} endpoint: {}", new Object[]{protocol, args, baseUrl, sseEndpoint});
        if (!this.isEndpointReachable(baseUrl + sseEndpoint)) {
            String diagnosis = this.diagnoseEndpoint(baseUrl, sseEndpoint);
            return String.format("Error: Cannot reach MCP Server endpoint at %s%s\n\n%s", baseUrl, sseEndpoint, diagnosis);
        }
        McpSyncClient client = null;
        try {
            HttpClientSseClientTransport.Builder transportBuilder = HttpClientSseClientTransport.builder((String)baseUrl).sseEndpoint(sseEndpoint);
            HttpClientSseClientTransport transport = transportBuilder.build();
            client = McpClient.sync((McpClientTransport)transport).build();
            logger.info("MCP Client initializing: baseUrl {} sseEndpoint {}", (Object)baseUrl, (Object)sseEndpoint);
            McpSchema.InitializeResult initializeResult = client.initialize();
            logger.info("MCP Client initialized: {}", (Object)initializeResult);
            String toolName = this.extractToolNameFromArgs(args);
            if (toolName == null || toolName.isEmpty()) {
                String string = "Error: Tool name not provided in arguments";
                return string;
            }
            McpSchema.CallToolRequest request = new McpSchema.CallToolRequest(toolName, args);
            logger.info("CallToolRequest: {}", (Object)request);
            McpSchema.CallToolResult result = client.callTool(request);
            logger.info("Tool call result: {}", (Object)result);
            String string = this.processToolResult(result);
            return string;
        }
        catch (Exception e) {
            logger.error("MCP stream call failed:", (Throwable)e);
            StringBuilder errorInfo = new StringBuilder();
            errorInfo.append("Error: MCP stream call failed - ").append(e.getMessage()).append("\n\n");
            if (e.getMessage().contains("Failed to wait for the message endpoint") || e.getMessage().contains("502") || e.getMessage().contains("connection")) {
                errorInfo.append("=== Connection Diagnosis ===\n");
                errorInfo.append("Target URL: ").append(baseUrl).append(sseEndpoint).append("\n");
                errorInfo.append("Protocol: ").append(protocol).append("\n");
                errorInfo.append("Service: ").append(serviceRef.getServiceName()).append("\n\n");
                String diagnosis = this.diagnoseEndpoint(baseUrl, sseEndpoint);
                errorInfo.append(diagnosis);
                errorInfo.append("\n=== Troubleshooting Steps ===\n");
                errorInfo.append("1. Verify the target server is running\n");
                errorInfo.append("2. Check if the server is accessible from this machine\n");
                errorInfo.append("3. Verify the endpoint path is correct\n");
                errorInfo.append("4. Check server logs for any errors\n");
                errorInfo.append("5. Verify network connectivity and firewall settings\n");
            }
            String string = errorInfo.toString();
            return string;
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (Exception e) {
                    logger.warn("Failed to close MCP client", (Throwable)e);
                }
            }
        }
    }

    private String processToolResult(McpSchema.CallToolResult result) {
        List list;
        List content = result.content();
        if (content instanceof List && !CollectionUtils.isEmpty((Collection)(list = content))) {
            Map map;
            Object first = list.get(0);
            if (first instanceof McpSchema.TextContent) {
                McpSchema.TextContent textContent = (McpSchema.TextContent)first;
                return textContent.text();
            }
            if (first instanceof Map && (map = (Map)first).containsKey("text")) {
                return map.get("text").toString();
            }
            return first.toString();
        }
        return content != null ? content.toString() : "No content returned";
    }

    public String extractToolNameFromArgs(Map<String, Object> args) {
        if (args.containsKey("toolName")) {
            return args.get("toolName").toString();
        }
        if (args.containsKey("tool_name")) {
            return args.get("tool_name").toString();
        }
        if (args.containsKey("name")) {
            return args.get("name").toString();
        }
        return null;
    }

    private boolean isEndpointReachable(String endpointUrl) {
        try {
            boolean reachable;
            logger.info("Checking endpoint reachability: {}", (Object)endpointUrl);
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(endpointUrl)).method("HEAD", HttpRequest.BodyPublishers.noBody()).timeout(Duration.ofSeconds(10L)).build();
            HttpResponse<Void> response = client.send(request, HttpResponse.BodyHandlers.discarding());
            int statusCode = response.statusCode();
            logger.info("Endpoint {} returned status code: {}", (Object)endpointUrl, (Object)statusCode);
            boolean bl = reachable = statusCode >= 200 && statusCode < 400;
            if (!reachable) {
                logger.warn("Endpoint {} is not reachable, status code: {}", (Object)endpointUrl, (Object)statusCode);
            }
            return reachable;
        }
        catch (Exception e) {
            logger.warn("Endpoint {} is not reachable: {}", (Object)endpointUrl, (Object)e.getMessage());
            return false;
        }
    }

    private String diagnoseEndpoint(String baseUrl, String endpoint) {
        StringBuilder diagnosis;
        block5: {
            diagnosis = new StringBuilder();
            String fullUrl = baseUrl + endpoint;
            diagnosis.append("=== Endpoint Diagnosis ===\n");
            diagnosis.append("Full URL: ").append(fullUrl).append("\n");
            try {
                diagnosis.append("1. Checking base URL: ").append(baseUrl).append("\n");
                boolean baseReachable = this.isEndpointReachable(baseUrl);
                diagnosis.append("   Base URL reachable: ").append(baseReachable ? "\u2705" : "\u274c").append("\n");
                diagnosis.append("2. Checking full endpoint: ").append(fullUrl).append("\n");
                boolean endpointReachable = this.isEndpointReachable(fullUrl);
                diagnosis.append("   Endpoint reachable: ").append(endpointReachable ? "\u2705" : "\u274c").append("\n");
                if (endpointReachable) break block5;
                diagnosis.append("3. Attempting GET request for more details...\n");
                try {
                    HttpClient client = HttpClient.newHttpClient();
                    HttpRequest request = HttpRequest.newBuilder().uri(URI.create(fullUrl)).method("GET", HttpRequest.BodyPublishers.noBody()).timeout(Duration.ofSeconds(5L)).build();
                    HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                    diagnosis.append("   Status Code: ").append(response.statusCode()).append("\n");
                    diagnosis.append("   Response Headers: ").append(response.headers()).append("\n");
                    if (response.statusCode() == 502) {
                        diagnosis.append("   \u274c 502 Bad Gateway - Server is not responding properly\n");
                        diagnosis.append("   Possible causes:\n");
                        diagnosis.append("   - Target server is down\n");
                        diagnosis.append("   - Server configuration error\n");
                        diagnosis.append("   - Network connectivity issues\n");
                        diagnosis.append("   - Proxy/gateway configuration problem\n");
                    }
                }
                catch (Exception e) {
                    diagnosis.append("   GET request failed: ").append(e.getMessage()).append("\n");
                }
            }
            catch (Exception e) {
                diagnosis.append("Diagnosis failed: ").append(e.getMessage()).append("\n");
            }
        }
        return diagnosis.toString();
    }

    public boolean establishConnection(String serviceName) {
        try {
            McpServerDetailInfo serverDetail = this.nacosMcpOperationService.getServerDetail(serviceName);
            if (serverDetail == null) {
                logger.error("Service not found: {}", (Object)serviceName);
                return false;
            }
            String protocol = serverDetail.getProtocol();
            McpServerRemoteServiceConfig remoteConfig = serverDetail.getRemoteServerConfig();
            if (remoteConfig == null || remoteConfig.getServiceRef() == null) {
                logger.error("Remote config or service ref is null for service: {}", (Object)serviceName);
                return false;
            }
            McpServiceRef serviceRef = remoteConfig.getServiceRef();
            McpEndpointInfo mcpEndpointInfo = this.nacosMcpOperationService.selectEndpoint(serviceRef);
            if (mcpEndpointInfo == null) {
                logger.error("No available endpoint found for service: {}", (Object)serviceName);
                return false;
            }
            McpSyncClient client = this.createClient(protocol, mcpEndpointInfo, remoteConfig);
            if (client != null) {
                this.clientConnections.put(serviceName, client);
                logger.info("Successfully established connection to service: {}", (Object)serviceName);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            logger.error("Failed to establish connection to service: {}", (Object)serviceName, (Object)e);
            return false;
        }
    }

    private McpSyncClient createClient(String protocol, McpEndpointInfo endpointInfo, McpServerRemoteServiceConfig remoteConfig) {
        try {
            String baseUrl = "http://" + endpointInfo.getAddress() + ":" + endpointInfo.getPort();
            String exportPath = remoteConfig.getExportPath();
            switch (protocol.toLowerCase()) {
                case "mcp-sse": 
                case "mcp-stream": {
                    String sseEndpoint = exportPath != null && !exportPath.isEmpty() ? exportPath : "/sse";
                    HttpClientSseClientTransport sseTransport = HttpClientSseClientTransport.builder((String)baseUrl).sseEndpoint(sseEndpoint).build();
                    return McpClient.sync((McpClientTransport)sseTransport).build();
                }
            }
            logger.warn("Unsupported protocol for client creation: {}", (Object)protocol);
            return null;
        }
        catch (Exception e) {
            logger.error("Failed to create MCP client for protocol: {}", (Object)protocol, (Object)e);
            return null;
        }
    }

    public void closeConnection(String serviceName) {
        McpSyncClient client = this.clientConnections.remove(serviceName);
        if (client != null) {
            try {
                client.close();
                logger.info("Closed connection to service: {}", (Object)serviceName);
            }
            catch (Exception e) {
                logger.warn("Failed to close connection to service: {}", (Object)serviceName, (Object)e);
            }
        }
    }

    public void closeAllConnections() {
        for (Map.Entry<String, McpSyncClient> entry : this.clientConnections.entrySet()) {
            try {
                entry.getValue().close();
                logger.info("Closed connection to service: {}", (Object)entry.getKey());
            }
            catch (Exception e) {
                logger.warn("Failed to close connection to service: {}", (Object)entry.getKey(), (Object)e);
            }
        }
        this.clientConnections.clear();
    }

    public boolean isConnected(String serviceName) {
        return this.clientConnections.containsKey(serviceName);
    }

    public int getConnectionCount() {
        return this.clientConnections.size();
    }

    public String debugServiceConnection(String serviceName) {
        try {
            StringBuilder debugInfo = new StringBuilder();
            debugInfo.append("=== MCP Service Connection Debug ===\n");
            debugInfo.append("Service Name: ").append(serviceName).append("\n\n");
            McpServerDetailInfo serverDetail = this.nacosMcpOperationService.getServerDetail(serviceName);
            if (serverDetail == null) {
                debugInfo.append("\u274c Service not found in Nacos\n");
                return debugInfo.toString();
            }
            debugInfo.append("\u2705 Service found in Nacos\n");
            debugInfo.append("Protocol: ").append(serverDetail.getProtocol()).append("\n");
            McpServerRemoteServiceConfig remoteConfig = serverDetail.getRemoteServerConfig();
            if (remoteConfig == null) {
                debugInfo.append("\u274c Remote config is null\n");
                return debugInfo.toString();
            }
            debugInfo.append("\u2705 Remote config found\n");
            McpServiceRef serviceRef = remoteConfig.getServiceRef();
            if (serviceRef == null) {
                debugInfo.append("\u274c Service ref is null\n");
                return debugInfo.toString();
            }
            debugInfo.append("\u2705 Service ref found\n");
            debugInfo.append("Service Ref Name: ").append(serviceRef.getServiceName()).append("\n");
            McpEndpointInfo mcpEndpointInfo = this.nacosMcpOperationService.selectEndpoint(serviceRef);
            if (mcpEndpointInfo == null) {
                debugInfo.append("\u274c No available endpoint found\n");
                return debugInfo.toString();
            }
            debugInfo.append("\u2705 Endpoint found\n");
            debugInfo.append("Address: ").append(mcpEndpointInfo.getAddress()).append("\n");
            debugInfo.append("Port: ").append(mcpEndpointInfo.getPort()).append("\n");
            String baseUrl = "http://" + mcpEndpointInfo.getAddress() + ":" + mcpEndpointInfo.getPort();
            String exportPath = remoteConfig.getExportPath();
            String endpoint = exportPath != null && !exportPath.isEmpty() ? exportPath : "/sse";
            String fullUrl = baseUrl + endpoint;
            debugInfo.append("Full URL: ").append(fullUrl).append("\n");
            boolean reachable = this.isEndpointReachable(fullUrl);
            debugInfo.append("Endpoint reachable: ").append(reachable ? "\u2705" : "\u274c").append("\n");
            if (!reachable) {
                debugInfo.append("\n");
                String diagnosis = this.diagnoseEndpoint(baseUrl, endpoint);
                debugInfo.append(diagnosis);
            }
            boolean connected = this.isConnected(serviceName);
            debugInfo.append("Connection cached: ").append(connected ? "\u2705" : "\u274c").append("\n");
            return debugInfo.toString();
        }
        catch (Exception e) {
            return "Error during debug: " + e.getMessage();
        }
    }

    public McpSyncClient getClient(String serviceName) {
        return this.clientConnections.get(serviceName);
    }
}

