/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.router.service;

import com.alibaba.cloud.ai.mcp.nacos.service.NacosMcpOperationService;
import com.alibaba.cloud.ai.mcp.router.core.discovery.McpServiceDiscovery;
import com.alibaba.cloud.ai.mcp.router.core.vectorstore.McpServerVectorStore;
import com.alibaba.cloud.ai.mcp.router.model.McpServerInfo;
import com.alibaba.cloud.ai.mcp.router.model.response.McpDebugResponse;
import com.alibaba.cloud.ai.mcp.router.model.response.McpServerAddResponse;
import com.alibaba.cloud.ai.mcp.router.model.response.McpServerSearchResponse;
import com.alibaba.cloud.ai.mcp.router.model.response.McpToolExecutionResponse;
import com.alibaba.cloud.ai.mcp.router.service.McpProxyService;
import com.alibaba.nacos.api.ai.model.mcp.McpServerDetailInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpTool;
import com.alibaba.nacos.api.ai.model.mcp.McpToolMeta;
import com.alibaba.nacos.api.ai.model.mcp.McpToolSpecification;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.tool.annotation.Tool;
import org.springframework.ai.tool.annotation.ToolParam;

public class McpRouterService {
    private static final Logger logger = LoggerFactory.getLogger(McpRouterService.class);
    private final McpServiceDiscovery mcpServiceDiscovery;
    private final McpServerVectorStore mcpServerVectorStore;
    private final NacosMcpOperationService nacosMcpOperationService;
    private final McpProxyService mcpProxyService;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public McpRouterService(McpServiceDiscovery mcpServiceDiscovery, McpServerVectorStore mcpServerVectorStore, NacosMcpOperationService nacosMcpOperationService, McpProxyService mcpProxyService) {
        this.mcpServiceDiscovery = mcpServiceDiscovery;
        this.mcpServerVectorStore = mcpServerVectorStore;
        this.nacosMcpOperationService = nacosMcpOperationService;
        this.mcpProxyService = mcpProxyService;
    }

    @Tool(description="\u6839\u636e\u4efb\u52a1\u63cf\u8ff0\u548c\u5173\u952e\u8bcd\u641c\u7d22\u5408\u9002\u7684 MCP Server\uff0c\u8fd4\u56de\u7ed3\u6784\u5316\u7684\u641c\u7d22\u7ed3\u679c")
    public McpServerSearchResponse searchMcpServer(@ToolParam(description="\u4efb\u52a1\u63cf\u8ff0\uff0c\u7528\u4e8e\u8bed\u4e49\u5339\u914d") String taskDescription, @ToolParam(description="\u5173\u952e\u8bcd\uff0c\u591a\u4e2a\u5173\u952e\u8bcd\u7528\u9017\u53f7\u5206\u9694", required=false) String keywords, @ToolParam(description="\u8fd4\u56de\u6570\u91cf\u9650\u5236\uff0c\u9ed8\u8ba45", required=false) Integer limit) {
        try {
            if (limit == null || limit <= 0) {
                limit = 5;
            }
            Object searchQuery = taskDescription;
            if (keywords != null && !keywords.trim().isEmpty()) {
                searchQuery = (String)searchQuery + " " + keywords;
            }
            logger.info("\u6267\u884c MCP Server \u641c\u7d22: query='{}', limit={}", searchQuery, (Object)limit);
            List<McpServerInfo> results = this.mcpServerVectorStore.search((String)searchQuery, limit);
            if (results.isEmpty()) {
                List<String> suggestions = List.of("\u5c1d\u8bd5\u4f7f\u7528\u66f4\u5177\u4f53\u7684\u4efb\u52a1\u63cf\u8ff0", "\u6dfb\u52a0\u76f8\u5173\u7684\u6280\u672f\u5173\u952e\u8bcd\uff08\u5982\uff1a\u6570\u636e\u5e93\u3001\u6587\u4ef6\u3001API\u7b49\uff09", "\u68c0\u67e5\u662f\u5426\u5df2\u6dfb\u52a0\u76f8\u5173\u7684 MCP Server", "\u4f7f\u7528 addMcpServer \u65b9\u6cd5\u6dfb\u52a0\u65b0\u7684\u670d\u52a1");
                McpServerSearchResponse response = McpServerSearchResponse.error((String)searchQuery, "\u672a\u627e\u5230\u5339\u914d\u7684 MCP Server");
                response.setSuggestions(suggestions);
                return response;
            }
            List<McpServerSearchResponse.McpServerSearchResult> searchResults = results.stream().map(McpServerSearchResponse.McpServerSearchResult::new).collect(Collectors.toList());
            logger.info("\u627e\u5230 {} \u4e2a\u5339\u914d\u7684 MCP Server", (Object)results.size());
            return McpServerSearchResponse.success((String)searchQuery, searchResults);
        }
        catch (Exception e) {
            logger.error("\u641c\u7d22 MCP Server \u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            return McpServerSearchResponse.error(taskDescription != null ? taskDescription : "", "\u641c\u7d22 MCP Server \u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage());
        }
    }

    @Tool(description="\u6dfb\u52a0\u5e76\u521d\u59cb\u5316\u4e00\u4e2aMCP Server\uff0c\u6839\u636eNacos\u4e2d\u7684\u914d\u7f6e\u4e0e\u8be5MCP Server\u5efa\u7acb\u8fde\u63a5\uff0c\u8fd4\u56de\u8be6\u7ec6\u7684\u670d\u52a1\u4fe1\u606f\u548c\u5de5\u5177\u5217\u8868")
    public McpServerAddResponse addMcpServer(@ToolParam(description="\u9700\u8981\u6dfb\u52a0\u7684MCP Server\u540d\u5b57") String mcpServerName) {
        try {
            boolean connected;
            logger.info("\u5f00\u59cb\u6dfb\u52a0\u5e76\u521d\u59cb\u5316 MCP Server: {}", (Object)mcpServerName);
            McpServerInfo serverInfo = this.mcpServiceDiscovery.getService(mcpServerName);
            if (serverInfo == null) {
                return McpServerAddResponse.error(mcpServerName, "\u672a\u627e\u5230 MCP Server\uff0c\u8bf7\u786e\u4fdd\u670d\u52a1\u5df2\u5728 Nacos \u4e2d\u6ce8\u518c\u3002\u8bf7\u68c0\u67e5\uff1a1. \u670d\u52a1\u540d\u79f0\u662f\u5426\u6b63\u786e 2. \u670d\u52a1\u662f\u5426\u5df2\u5728 Nacos \u4e2d\u6ce8\u518c 3. Nacos \u914d\u7f6e\u662f\u5426\u6b63\u786e");
            }
            boolean added = this.mcpServerVectorStore.addServer(serverInfo);
            if (!added) {
                logger.warn("\u670d\u52a1\u53ef\u80fd\u5df2\u5b58\u5728\u4e8e\u5411\u91cf\u5b58\u50a8\u4e2d: {}", (Object)mcpServerName);
            }
            String connectionMessage = (connected = this.mcpProxyService.establishConnection(mcpServerName)) ? "\u8fde\u63a5\u6210\u529f" : "\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u670d\u52a1\u662f\u5426\u6b63\u5728\u8fd0\u884c";
            String connectionUrl = String.format("%s://%s", serverInfo.getProtocol(), serverInfo.getEndpoint());
            McpServerAddResponse.McpConnectionStatus connectionStatus = new McpServerAddResponse.McpConnectionStatus(connected, connectionUrl, connectionMessage);
            List<McpToolInfo> tools = this.getMcpServerTools(mcpServerName);
            List<McpServerAddResponse.McpToolInfo> toolInfoList = this.convertToMcpToolInfoList(tools);
            McpServerAddResponse.McpServerServiceInfo serviceInfo = new McpServerAddResponse.McpServerServiceInfo(serverInfo.getName(), serverInfo.getDescription(), serverInfo.getProtocol(), serverInfo.getVersion(), serverInfo.getEndpoint(), serverInfo.getTags());
            McpServerAddResponse.McpUsageGuide usageGuide = this.createUsageGuide(mcpServerName, tools);
            return McpServerAddResponse.success(mcpServerName, serviceInfo, connectionStatus, toolInfoList, usageGuide);
        }
        catch (Exception e) {
            logger.error("\u6dfb\u52a0\u5e76\u521d\u59cb\u5316 MCP Server \u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)mcpServerName, (Object)e);
            return McpServerAddResponse.error(mcpServerName, "\u6dfb\u52a0\u5e76\u521d\u59cb\u5316 MCP Server \u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage());
        }
    }

    @Tool(description="\u4f7f\u7528\u6307\u5b9a MCP Server \u7684\u5de5\u5177\uff0c\u8fd4\u56de\u8be6\u7ec6\u7684\u6267\u884c\u7ed3\u679c\u548c\u5143\u4fe1\u606f")
    public McpToolExecutionResponse useTool(@ToolParam(description="\u76ee\u6807\u670d\u52a1\u540d\u79f0") String serviceName, @ToolParam(description="\u5de5\u5177\u540d\u79f0") String toolName, @ToolParam(description="\u5de5\u5177\u53c2\u6570\uff0cJSON \u683c\u5f0f") String parameters) {
        McpToolExecutionResponse.McpExecutionMeta executionMeta = null;
        HashMap<String, Object> args = new HashMap();
        try {
            boolean connected;
            args = this.parseParameters(parameters);
            McpServerInfo serverInfo = this.mcpServerVectorStore.getServer(serviceName);
            if (serverInfo == null) {
                return McpToolExecutionResponse.error(serviceName, toolName, args, "\u672a\u627e\u5230 MCP Server\uff0c\u8bf7\u5148\u4f7f\u7528 addMcpServer \u65b9\u6cd5\u6dfb\u52a0\u8be5\u670d\u52a1");
            }
            String connectionUrl = String.format("%s://%s", serverInfo.getProtocol(), serverInfo.getEndpoint());
            executionMeta = McpToolExecutionResponse.McpExecutionMeta.start(serverInfo.getProtocol(), connectionUrl);
            if (!this.mcpProxyService.isConnected(serviceName) && !(connected = this.mcpProxyService.establishConnection(serviceName))) {
                return McpToolExecutionResponse.error(serviceName, toolName, args, "\u65e0\u6cd5\u8fde\u63a5\u5230 MCP Server\uff0c\u8bf7\u68c0\u67e5\u670d\u52a1\u72b6\u6001\u548c\u7f51\u7edc\u8fde\u63a5");
            }
            logger.info("\u6267\u884c MCP \u5de5\u5177: service='{}', tool='{}', args={}", new Object[]{serviceName, toolName, args});
            String rawResult = this.mcpProxyService.callTool(serviceName, toolName, args);
            executionMeta.complete();
            McpToolExecutionResponse.McpToolExecutionResult result = this.processExecutionResult(rawResult);
            logger.info("MCP \u5de5\u5177\u6267\u884c\u5b8c\u6210: service='{}', tool='{}', duration={}ms", new Object[]{serviceName, toolName, executionMeta.getExecutionDurationMs()});
            return McpToolExecutionResponse.success(serviceName, toolName, args, result, executionMeta);
        }
        catch (Exception e) {
            if (executionMeta != null) {
                executionMeta.complete();
            }
            logger.error("\u4f7f\u7528\u5de5\u5177\u65f6\u53d1\u751f\u9519\u8bef: service='{}', tool='{}'", new Object[]{serviceName, toolName, e});
            return McpToolExecutionResponse.error(serviceName, toolName, args, "\u5de5\u5177\u6267\u884c\u5931\u8d25: " + e.getMessage());
        }
    }

    private List<McpToolInfo> getMcpServerTools(String serviceName) {
        ArrayList<McpToolInfo> tools = new ArrayList<McpToolInfo>();
        try {
            McpServerDetailInfo serverDetail = this.getServerDetailFromNacos(serviceName);
            if (serverDetail != null && serverDetail.getToolSpec() != null) {
                McpToolSpecification toolSpec = serverDetail.getToolSpec();
                List toolsList = toolSpec.getTools();
                Map toolsMeta = toolSpec.getToolsMeta();
                if (toolsList != null) {
                    for (McpTool tool : toolsList) {
                        boolean enabled;
                        String toolName = tool.getName();
                        McpToolMeta metaInfo = toolsMeta != null ? (McpToolMeta)toolsMeta.get(toolName) : null;
                        boolean bl = enabled = metaInfo == null || metaInfo.isEnabled();
                        if (!enabled) {
                            logger.debug("Tool {} is disabled, skipping", (Object)toolName);
                            continue;
                        }
                        Map<String, String> parameters = this.parseToolParameters(tool.getInputSchema());
                        McpToolInfo toolInfo = new McpToolInfo(toolName, tool.getDescription(), parameters);
                        tools.add(toolInfo);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6 MCP Server \u5de5\u5177\u5217\u8868\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)serviceName, (Object)e);
        }
        return tools;
    }

    private McpServerDetailInfo getServerDetailFromNacos(String serviceName) {
        try {
            return this.nacosMcpOperationService.getServerDetail(serviceName);
        }
        catch (Exception e) {
            logger.error("\u4ece Nacos \u83b7\u53d6\u670d\u52a1\u8be6\u60c5\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)serviceName, (Object)e);
            return null;
        }
    }

    private Map<String, String> parseToolParameters(Map<String, Object> inputSchema) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        try {
            if (inputSchema != null && inputSchema.containsKey("properties")) {
                Map properties = (Map)inputSchema.get("properties");
                for (Map.Entry entry : properties.entrySet()) {
                    String paramName = (String)entry.getKey();
                    Map paramInfo = (Map)entry.getValue();
                    String description = paramInfo.containsKey("description") ? (String)paramInfo.get("description") : "\u65e0\u63cf\u8ff0";
                    parameters.put(paramName, description);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u5de5\u5177\u53c2\u6570\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        return parameters;
    }

    private Map<String, Object> parseParameters(String parameters) {
        try {
            if (parameters == null || parameters.trim().isEmpty()) {
                return new HashMap<String, Object>();
            }
            JsonNode paramsNode = this.objectMapper.readTree(parameters);
            return (Map)this.objectMapper.convertValue((Object)paramsNode, Map.class);
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u5de5\u5177\u53c2\u6570\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            return new HashMap<String, Object>();
        }
    }

    @Tool(description="\u8c03\u8bd5 MCP \u670d\u52a1\u8fde\u63a5\u72b6\u6001\uff0c\u63d0\u4f9b\u8be6\u7ec6\u7684\u8bca\u65ad\u4fe1\u606f\u548c\u95ee\u9898\u6392\u67e5\u5efa\u8bae")
    public McpDebugResponse debugMcpService(@ToolParam(description="\u670d\u52a1\u540d\u79f0") String serviceName) {
        try {
            logger.info("\u5f00\u59cb\u8c03\u8bd5 MCP \u670d\u52a1: {}", (Object)serviceName);
            McpDebugResponse.McpServiceStatus serviceStatus = this.checkServiceStatus(serviceName);
            McpDebugResponse.McpConnectionDiagnosis connectionDiagnosis = this.performConnectionDiagnosis(serviceName);
            List<String> suggestions = this.generateTroubleshootingSuggestions(serviceStatus, connectionDiagnosis);
            logger.info("MCP \u670d\u52a1\u8c03\u8bd5\u5b8c\u6210: {}", (Object)serviceName);
            return McpDebugResponse.success(serviceName, serviceStatus, connectionDiagnosis, suggestions);
        }
        catch (Exception e) {
            logger.error("\u8c03\u8bd5\u670d\u52a1\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)serviceName, (Object)e);
            return McpDebugResponse.error(serviceName, "\u8c03\u8bd5\u670d\u52a1\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage());
        }
    }

    private List<McpServerAddResponse.McpToolInfo> convertToMcpToolInfoList(List<McpToolInfo> tools) {
        return tools.stream().map(tool -> {
            Map<String, McpServerAddResponse.McpToolParameter> parameters = tool.getParameters().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new McpServerAddResponse.McpToolParameter("string", (String)entry.getValue(), false, null)));
            return new McpServerAddResponse.McpToolInfo(tool.getName(), tool.getDescription(), parameters, true);
        }).collect(Collectors.toList());
    }

    private McpServerAddResponse.McpUsageGuide createUsageGuide(String serviceName, List<McpToolInfo> tools) {
        String howToUse = String.format("\u4f7f\u7528 useTool \u65b9\u6cd5\u8c03\u7528\u5de5\u5177\uff1a\n- \u53c2\u65701: serviceName = \"%s\"\n- \u53c2\u65702: toolName = \"\u5de5\u5177\u540d\u79f0\"\n- \u53c2\u65703: parameters = \"{\\\"\u53c2\u6570\u540d\\\":\\\"\u53c2\u6570\u503c\\\"}\"", serviceName);
        String exampleCall = "";
        if (!tools.isEmpty()) {
            McpToolInfo firstTool = tools.get(0);
            exampleCall = String.format("useTool(\"%s\", \"%s\", \"{}\")", serviceName, firstTool.getName());
        }
        List<String> operations = List.of("useTool - \u6267\u884c\u5de5\u5177", "searchMcpServer - \u641c\u7d22\u670d\u52a1", "debugMcpService - \u8c03\u8bd5\u670d\u52a1\u8fde\u63a5");
        return new McpServerAddResponse.McpUsageGuide(howToUse, exampleCall, operations);
    }

    private McpToolExecutionResponse.McpToolExecutionResult processExecutionResult(String rawResult) {
        if (rawResult == null) {
            return McpToolExecutionResponse.McpToolExecutionResult.text("No result returned");
        }
        try {
            JsonNode jsonNode = this.objectMapper.readTree(rawResult);
            return McpToolExecutionResponse.McpToolExecutionResult.json(jsonNode, rawResult);
        }
        catch (Exception e) {
            return McpToolExecutionResponse.McpToolExecutionResult.text(rawResult);
        }
    }

    private McpDebugResponse.McpServiceStatus checkServiceStatus(String serviceName) {
        McpDebugResponse.McpServiceStatus status = new McpDebugResponse.McpServiceStatus();
        HashMap<String, String> serviceInfo = new HashMap<String, String>();
        McpServerInfo serverInfo = this.mcpServerVectorStore.getServer(serviceName);
        status.setFoundInVectorStore(serverInfo != null);
        if (serverInfo != null) {
            serviceInfo.put("name", serverInfo.getName());
            serviceInfo.put("description", serverInfo.getDescription());
            serviceInfo.put("protocol", serverInfo.getProtocol());
            serviceInfo.put("version", serverInfo.getVersion());
            serviceInfo.put("endpoint", serverInfo.getEndpoint());
        }
        try {
            McpServerDetailInfo nacosInfo = this.nacosMcpOperationService.getServerDetail(serviceName);
            status.setFoundInNacos(nacosInfo != null);
            status.setRemoteConfigValid(nacosInfo != null && nacosInfo.getRemoteServerConfig() != null);
            status.setServiceRefValid(nacosInfo != null && nacosInfo.getRemoteServerConfig() != null && nacosInfo.getRemoteServerConfig().getServiceRef() != null);
        }
        catch (Exception e) {
            status.setFoundInNacos(false);
            status.setRemoteConfigValid(false);
            status.setServiceRefValid(false);
        }
        status.setConnectionCached(this.mcpProxyService.isConnected(serviceName));
        status.setServiceInfo(serviceInfo);
        return status;
    }

    private McpDebugResponse.McpConnectionDiagnosis performConnectionDiagnosis(String serviceName) {
        McpDebugResponse.McpConnectionDiagnosis diagnosis = new McpDebugResponse.McpConnectionDiagnosis();
        ArrayList<String> details = new ArrayList<String>();
        try {
            String proxyDebugInfo = this.mcpProxyService.debugServiceConnection(serviceName);
            diagnosis.setFullUrl(this.extractUrlFromDebugInfo(proxyDebugInfo));
            diagnosis.setBaseUrlReachable(proxyDebugInfo.contains("Base URL reachable: \u2705"));
            diagnosis.setEndpointReachable(proxyDebugInfo.contains("Endpoint reachable: \u2705"));
            Integer statusCode = this.extractStatusCodeFromDebugInfo(proxyDebugInfo);
            diagnosis.setHttpStatusCode(statusCode);
            details.add("\u5b8c\u6574\u8bca\u65ad\u4fe1\u606f\uff1a");
            details.add(proxyDebugInfo);
        }
        catch (Exception e) {
            diagnosis.setNetworkError("\u8bca\u65ad\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef: " + e.getMessage());
            details.add("\u8bca\u65ad\u5931\u8d25: " + e.getMessage());
        }
        diagnosis.setDiagnosisDetails(details);
        return diagnosis;
    }

    private List<String> generateTroubleshootingSuggestions(McpDebugResponse.McpServiceStatus serviceStatus, McpDebugResponse.McpConnectionDiagnosis connectionDiagnosis) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (!serviceStatus.isFoundInVectorStore()) {
            suggestions.add("\u670d\u52a1\u672a\u5728\u5411\u91cf\u5b58\u50a8\u4e2d\u627e\u5230\uff0c\u8bf7\u4f7f\u7528 addMcpServer \u65b9\u6cd5\u6dfb\u52a0\u670d\u52a1");
        }
        if (!serviceStatus.isFoundInNacos()) {
            suggestions.add("\u670d\u52a1\u672a\u5728 Nacos \u4e2d\u627e\u5230\uff0c\u8bf7\u68c0\u67e5\u670d\u52a1\u540d\u79f0\u548c Nacos \u914d\u7f6e");
        }
        if (!serviceStatus.isRemoteConfigValid()) {
            suggestions.add("\u8fdc\u7a0b\u914d\u7f6e\u65e0\u6548\uff0c\u8bf7\u68c0\u67e5 Nacos \u4e2d\u7684\u670d\u52a1\u914d\u7f6e");
        }
        if (!connectionDiagnosis.isEndpointReachable()) {
            suggestions.add("\u7aef\u70b9\u4e0d\u53ef\u8fbe\uff0c\u8bf7\u68c0\u67e5\u76ee\u6807\u670d\u52a1\u662f\u5426\u6b63\u5728\u8fd0\u884c");
            suggestions.add("\u68c0\u67e5\u7f51\u7edc\u8fde\u63a5\u548c\u9632\u706b\u5899\u8bbe\u7f6e");
            suggestions.add("\u9a8c\u8bc1\u670d\u52a1\u5730\u5740\u548c\u7aef\u53e3\u914d\u7f6e");
        }
        if (connectionDiagnosis.getHttpStatusCode() != null && connectionDiagnosis.getHttpStatusCode() >= 500) {
            suggestions.add("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u76ee\u6807\u670d\u52a1\u7684\u65e5\u5fd7");
        }
        if (suggestions.isEmpty()) {
            suggestions.add("\u670d\u52a1\u72b6\u6001\u6b63\u5e38\uff0c\u5982\u6709\u95ee\u9898\u8bf7\u68c0\u67e5\u5177\u4f53\u7684\u5de5\u5177\u8c03\u7528\u53c2\u6570");
        }
        return suggestions;
    }

    private String extractUrlFromDebugInfo(String debugInfo) {
        String[] lines;
        for (String line : lines = debugInfo.split("\n")) {
            if (!line.contains("Full URL:")) continue;
            return line.substring(line.indexOf("Full URL:") + 9).trim();
        }
        return null;
    }

    private Integer extractStatusCodeFromDebugInfo(String debugInfo) {
        String[] lines;
        for (String line : lines = debugInfo.split("\n")) {
            if (!line.contains("Status Code:")) continue;
            try {
                String statusStr = line.substring(line.indexOf("Status Code:") + 12).trim();
                return Integer.parseInt(statusStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static class McpToolInfo {
        private final String name;
        private final String description;
        private final Map<String, String> parameters;

        public McpToolInfo(String name, String description, Map<String, String> parameters) {
            this.name = name;
            this.description = description;
            this.parameters = parameters;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }
    }
}

