/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.time.LocalDateTime;
import org.springframework.format.annotation.DateTimeFormat;

@TableName(value="datasource")
public class Datasource {
    @TableId(value="id", type=IdType.AUTO)
    private Integer id;
    @TableField(value="name")
    private String name;
    @TableField(value="type")
    private String type;
    @TableField(value="host")
    private String host;
    @TableField(value="port")
    private Integer port;
    @TableField(value="database_name")
    private String databaseName;
    @TableField(value="username")
    private String username;
    @TableField(value="password")
    private String password;
    @TableField(value="connection_url")
    private String connectionUrl;
    @TableField(value="status")
    private String status;
    @TableField(value="test_status")
    private String testStatus;
    @TableField(value="description")
    private String description;
    @TableField(value="creator_id")
    private Long creatorId;
    @TableField(value="create_time", fill=FieldFill.INSERT)
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    @TableField(value="update_time", fill=FieldFill.INSERT_UPDATE)
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;

    public Datasource() {
    }

    public Datasource(String name, String type, String host, Integer port, String databaseName, String username, String password) {
        this.name = name;
        this.type = type;
        this.host = host;
        this.port = port;
        this.databaseName = databaseName;
        this.username = username;
        this.password = password;
        this.status = "active";
        this.testStatus = "unknown";
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getTestStatus() {
        return this.testStatus;
    }

    public void setTestStatus(String testStatus) {
        this.testStatus = testStatus;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(Long creatorId) {
        this.creatorId = creatorId;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public LocalDateTime getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public void generateConnectionUrl() {
        if (this.host != null && this.port != null && this.databaseName != null) {
            if ("mysql".equalsIgnoreCase(this.type)) {
                this.connectionUrl = String.format("jdbc:mysql://%s:%d/%s?useUnicode=true&characterEncoding=utf-8&zeroDateTimeBehavior=convertToNull&transformedBitIsBoolean=true&allowMultiQueries=true&allowPublicKeyRetrieval=true&useSSL=false&serverTimezone=Asia/Shanghai", this.host, this.port, this.databaseName);
            } else if ("postgresql".equalsIgnoreCase(this.type)) {
                this.connectionUrl = String.format("jdbc:postgresql://%s:%d/%s?useUnicode=true&characterEncoding=utf-8&useSSL=false&serverTimezone=Asia/Shanghai", this.host, this.port, this.databaseName);
            }
        }
    }

    public String toString() {
        return "Datasource{id=" + this.id + ", name='" + this.name + "', type='" + this.type + "', host='" + this.host + "', port=" + this.port + ", databaseName='" + this.databaseName + "', status='" + this.status + "', testStatus='" + this.testStatus + "', createTime=" + this.createTime + ", updateTime=" + this.updateTime + "}";
    }
}

