/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.node;

import com.alibaba.cloud.ai.dto.schema.SchemaDTO;
import com.alibaba.cloud.ai.enums.StreamResponseType;
import com.alibaba.cloud.ai.graph.NodeOutput;
import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.action.NodeAction;
import com.alibaba.cloud.ai.graph.async.AsyncGenerator;
import com.alibaba.cloud.ai.prompt.PromptConstant;
import com.alibaba.cloud.ai.prompt.PromptHelper;
import com.alibaba.cloud.ai.util.StateUtils;
import com.alibaba.cloud.ai.util.StreamingChatGeneratorUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.model.ChatResponse;
import reactor.core.publisher.Flux;

public class PlannerNode
implements NodeAction {
    private static final Logger logger = LoggerFactory.getLogger(PlannerNode.class);
    private final ChatClient chatClient;

    public PlannerNode(ChatClient.Builder chatClientBuilder) {
        this.chatClient = chatClientBuilder.build();
    }

    public Map<String, Object> apply(OverAllState state) throws Exception {
        String userPrompt;
        logger.info("Entering {} node", (Object)this.getClass().getSimpleName());
        String input = (String)state.value("input").orElseThrow();
        String businessKnowledgePrompt = state.value("BUSINESS_KNOWLEDGE").orElse("");
        String semanticModelPrompt = state.value("SEMANTIC_MODEL").orElse("");
        SchemaDTO schemaDTO = (SchemaDTO)state.value("TABLE_RELATION_OUTPUT").orElseThrow();
        String schemaStr = PromptHelper.buildMixMacSqlDbPrompt(schemaDTO, true);
        String validationError = StateUtils.getStringValue(state, "PLAN_VALIDATION_ERROR", null);
        if (validationError != null) {
            logger.warn("This is a plan repair attempt. Previous error: {}", (Object)validationError);
            String previousPlan = StateUtils.getStringValue(state, "PLANNER_NODE_OUTPUT", "");
            userPrompt = String.format("The previous plan you generated failed validation with the following error: %s\n\nHere is the faulty plan:\n%s\n\nPlease correct the plan and provide a new, valid one to answer the original question: %s", validationError, previousPlan, input);
        } else {
            userPrompt = input;
        }
        Map<String, String> params = Map.of("user_question", userPrompt, "schema", schemaStr, "business_knowledge", businessKnowledgePrompt, "semantic_model", semanticModelPrompt);
        String plannerPrompt = PromptConstant.getPlannerPromptTemplate().render(params);
        Flux chatResponseFlux = this.chatClient.prompt().user(plannerPrompt).stream().chatResponse();
        AsyncGenerator<? extends NodeOutput> generator = StreamingChatGeneratorUtil.createStreamingGeneratorWithMessages(this.getClass(), state, v -> Map.of("PLANNER_NODE_OUTPUT", v), (Flux<ChatResponse>)chatResponseFlux, StreamResponseType.PLAN_GENERATION);
        return Map.of("PLANNER_NODE_OUTPUT", generator);
    }
}

