/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.node;

import com.alibaba.cloud.ai.enums.StreamResponseType;
import com.alibaba.cloud.ai.graph.NodeOutput;
import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.action.NodeAction;
import com.alibaba.cloud.ai.graph.async.AsyncGenerator;
import com.alibaba.cloud.ai.service.base.BaseSchemaService;
import com.alibaba.cloud.ai.util.ChatResponseUtil;
import com.alibaba.cloud.ai.util.StateUtils;
import com.alibaba.cloud.ai.util.StreamingChatGeneratorUtil;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.document.Document;
import reactor.core.publisher.Flux;

public class SchemaRecallNode
implements NodeAction {
    private static final Logger logger = LoggerFactory.getLogger(SchemaRecallNode.class);
    private final BaseSchemaService baseSchemaService;

    public SchemaRecallNode(BaseSchemaService baseSchemaService) {
        this.baseSchemaService = baseSchemaService;
    }

    public Map<String, Object> apply(OverAllState state) throws Exception {
        List<List<Document>> columnDocumentsByKeywords;
        List<Document> tableDocuments;
        logger.info("Entering {} node", (Object)this.getClass().getSimpleName());
        String input = StateUtils.getStringValue(state, "input");
        List<String> keywords = StateUtils.getListValue(state, "KEYWORD_EXTRACT_NODE_OUTPUT");
        String agentId = StateUtils.getStringValue(state, "agentId");
        if (agentId != null && !agentId.trim().isEmpty()) {
            logger.info("Using agent-specific schema recall for agent: {}", (Object)agentId);
            tableDocuments = this.baseSchemaService.getTableDocumentsForAgent(agentId, input);
            columnDocumentsByKeywords = this.baseSchemaService.getColumnDocumentsByKeywordsForAgent(agentId, keywords);
        } else {
            logger.info("Using global schema recall (no agentId provided)");
            tableDocuments = this.baseSchemaService.getTableDocuments(input);
            columnDocumentsByKeywords = this.baseSchemaService.getColumnDocumentsByKeywords(keywords);
        }
        logger.info("[{}] Schema recall results - table documents count: {}, keyword-related column document groups: {}", new Object[]{this.getClass().getSimpleName(), tableDocuments.size(), columnDocumentsByKeywords.size()});
        Flux displayFlux = Flux.create(emitter -> {
            emitter.next((Object)ChatResponseUtil.createStatusResponse("\u5f00\u59cb\u53ec\u56deSchema\u4fe1\u606f..."));
            emitter.next((Object)ChatResponseUtil.createStatusResponse("\u8868\u4fe1\u606f\u53ec\u56de\u5b8c\u6210\uff0c\u6570\u91cf: " + tableDocuments.size()));
            emitter.next((Object)ChatResponseUtil.createStatusResponse("\u5217\u4fe1\u606f\u53ec\u56de\u5b8c\u6210\uff0c\u6570\u91cf: " + columnDocumentsByKeywords.size()));
            emitter.next((Object)ChatResponseUtil.createStatusResponse("Schema\u4fe1\u606f\u53ec\u56de\u5b8c\u6210."));
            emitter.complete();
        });
        AsyncGenerator<? extends NodeOutput> generator = StreamingChatGeneratorUtil.createStreamingGeneratorWithMessages(this.getClass(), state, currentState -> {
            logger.info("Table document details: {}", (Object)tableDocuments);
            logger.info("Keyword-related column document details: {}", (Object)columnDocumentsByKeywords);
            return Map.of("TABLE_DOCUMENTS_FOR_SCHEMA", tableDocuments, "COLUMN_DOCUMENTS_BY_KEYWORDS_OUTPUT", columnDocumentsByKeywords);
        }, (Flux<ChatResponse>)displayFlux, StreamResponseType.SCHEMA_RECALL);
        return Map.of("SCHEMA_RECALL_NODE_OUTPUT", generator);
    }
}

