/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.prompt;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.StreamUtils;

public class PromptLoader {
    private static final String PROMPT_PATH_PREFIX = "prompts/";
    private static final ConcurrentHashMap<String, String> promptCache = new ConcurrentHashMap();

    public static String loadPrompt(String promptName) {
        return promptCache.computeIfAbsent(promptName, name -> {
            try {
                String fileName = PROMPT_PATH_PREFIX + name + ".txt";
                ClassPathResource resource = new ClassPathResource(fileName);
                if (!resource.exists()) {
                    throw new IllegalArgumentException("\u63d0\u793a\u8bcd\u6587\u4ef6\u4e0d\u5b58\u5728: " + fileName);
                }
                return StreamUtils.copyToString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new RuntimeException("\u52a0\u8f7d\u63d0\u793a\u8bcd\u5931\u8d25: " + name, e);
            }
        });
    }

    public static void clearCache() {
        promptCache.clear();
    }

    public static int getCacheSize() {
        return promptCache.size();
    }
}

