/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.service;

import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;

@Service
public class LlmService {
    private final ChatClient chatClient;

    public LlmService(ChatClient chatClient) {
        this.chatClient = chatClient;
    }

    public String call(String prompt) {
        return this.chatClient.prompt().user(prompt).call().content();
    }

    public String callWithSystemPrompt(String system, String user) {
        return this.chatClient.prompt().system(system).user(user).call().content();
    }

    public Flux<ChatResponse> streamCall(String prompt) {
        return this.chatClient.prompt().user(prompt).stream().chatResponse();
    }

    public Flux<ChatResponse> streamCallWithSystemPrompt(String system, String user) {
        return this.chatClient.prompt().system(system).user(user).stream().chatResponse();
    }
}

