/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.service.simple;

import com.alibaba.cloud.ai.connector.accessor.Accessor;
import com.alibaba.cloud.ai.connector.bo.ColumnInfoBO;
import com.alibaba.cloud.ai.connector.bo.DbQueryParameter;
import com.alibaba.cloud.ai.connector.bo.ForeignKeyInfoBO;
import com.alibaba.cloud.ai.connector.bo.TableInfoBO;
import com.alibaba.cloud.ai.connector.config.DbConfig;
import com.alibaba.cloud.ai.request.DeleteRequest;
import com.alibaba.cloud.ai.request.SchemaInitRequest;
import com.alibaba.cloud.ai.service.base.BaseVectorStoreService;
import com.alibaba.cloud.ai.service.simple.AgentVectorStoreManager;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.document.Document;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.vectorstore.SearchRequest;
import org.springframework.ai.vectorstore.SimpleVectorStore;
import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.FilterExpressionBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
public class SimpleVectorStoreService
extends BaseVectorStoreService {
    private static final Logger log = LoggerFactory.getLogger(SimpleVectorStoreService.class);
    private final SimpleVectorStore vectorStore;
    private final AgentVectorStoreManager agentVectorStoreManager;
    private final Gson gson;
    private final Accessor dbAccessor;
    private final DbConfig dbConfig;
    private final EmbeddingModel embeddingModel;

    @Autowired
    public SimpleVectorStoreService(EmbeddingModel embeddingModel, Gson gson, @Qualifier(value="mysqlAccessor") Accessor dbAccessor, DbConfig dbConfig, AgentVectorStoreManager agentVectorStoreManager) {
        log.info("Initializing SimpleVectorStoreService with EmbeddingModel: {}", (Object)embeddingModel.getClass().getSimpleName());
        this.gson = gson;
        this.dbAccessor = dbAccessor;
        this.dbConfig = dbConfig;
        this.embeddingModel = embeddingModel;
        this.agentVectorStoreManager = agentVectorStoreManager;
        this.vectorStore = SimpleVectorStore.builder((EmbeddingModel)embeddingModel).build();
        log.info("SimpleVectorStoreService initialized successfully with AgentVectorStoreManager");
    }

    @Override
    protected EmbeddingModel getEmbeddingModel() {
        return this.embeddingModel;
    }

    @Override
    public Boolean schema(SchemaInitRequest schemaInitRequest) throws Exception {
        log.info("Starting schema initialization for database: {}, schema: {}, tables: {}", new Object[]{schemaInitRequest.getDbConfig().getUrl(), schemaInitRequest.getDbConfig().getSchema(), schemaInitRequest.getTables()});
        DbConfig dbConfig = schemaInitRequest.getDbConfig();
        DbQueryParameter dqp = DbQueryParameter.from((DbConfig)dbConfig).setSchema(dbConfig.getSchema()).setTables(schemaInitRequest.getTables());
        DeleteRequest deleteRequest = new DeleteRequest();
        deleteRequest.setVectorType("column");
        this.deleteDocuments(deleteRequest);
        deleteRequest.setVectorType("table");
        this.deleteDocuments(deleteRequest);
        log.debug("Fetching foreign keys from database");
        List foreignKeyInfoBOS = this.dbAccessor.showForeignKeys(dbConfig, dqp);
        log.debug("Found {} foreign keys", (Object)foreignKeyInfoBOS.size());
        Map<String, List<String>> foreignKeyMap = this.buildForeignKeyMap(foreignKeyInfoBOS);
        log.debug("Fetching tables from database");
        List tableInfoBOS = this.dbAccessor.fetchTables(dbConfig, dqp);
        log.info("Found {} tables to process", (Object)tableInfoBOS.size());
        for (TableInfoBO tableInfoBO : tableInfoBOS) {
            log.debug("Processing table: {}", (Object)tableInfoBO.getName());
            this.processTable(tableInfoBO, dqp, dbConfig, foreignKeyMap);
        }
        log.debug("Converting columns to documents");
        List columnDocuments = tableInfoBOS.stream().flatMap(table -> {
            try {
                dqp.setTable(table.getName());
                return this.dbAccessor.showColumns(dbConfig, dqp).stream().map(column -> this.convertToDocument((TableInfoBO)table, (ColumnInfoBO)column));
            }
            catch (Exception e) {
                log.error("Error processing columns for table: {}", (Object)table.getName(), (Object)e);
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        log.info("Adding {} column documents to vector store", (Object)columnDocuments.size());
        this.vectorStore.add(columnDocuments);
        log.debug("Converting tables to documents");
        List tableDocuments = tableInfoBOS.stream().map(this::convertTableToDocument).collect(Collectors.toList());
        log.info("Adding {} table documents to vector store", (Object)tableDocuments.size());
        this.vectorStore.add(tableDocuments);
        log.info("Schema initialization completed successfully. Total documents added: {}", (Object)(columnDocuments.size() + tableDocuments.size()));
        return true;
    }

    private void processTable(TableInfoBO tableInfoBO, DbQueryParameter dqp, DbConfig dbConfig, Map<String, List<String>> foreignKeyMap) throws Exception {
        dqp.setTable(tableInfoBO.getName());
        List columnInfoBOS = this.dbAccessor.showColumns(dbConfig, dqp);
        for (ColumnInfoBO columnInfoBO : columnInfoBOS) {
            dqp.setColumn(columnInfoBO.getName());
            List<String> sampleColumn = this.dbAccessor.sampleColumn(dbConfig, dqp);
            sampleColumn = ((List)Optional.ofNullable(sampleColumn).orElse(new ArrayList())).stream().filter(Objects::nonNull).distinct().limit(3L).filter(s -> s.length() <= 100).toList();
            columnInfoBO.setTableName(tableInfoBO.getName());
            columnInfoBO.setSamples(this.gson.toJson(sampleColumn));
        }
        ColumnInfoBO primaryColumnDO = columnInfoBOS.stream().filter(ColumnInfoBO::isPrimary).findFirst().orElse(new ColumnInfoBO());
        tableInfoBO.setPrimaryKey(primaryColumnDO.getName());
        tableInfoBO.setForeignKey(String.join((CharSequence)"\u3001", foreignKeyMap.getOrDefault(tableInfoBO.getName(), new ArrayList())));
    }

    public Document convertToDocument(TableInfoBO tableInfoBO, ColumnInfoBO columnInfoBO) {
        log.debug("Converting column to document: table={}, column={}", (Object)tableInfoBO.getName(), (Object)columnInfoBO.getName());
        String text = Optional.ofNullable(columnInfoBO.getDescription()).orElse(columnInfoBO.getName());
        String id = tableInfoBO.getName() + "." + columnInfoBO.getName();
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("id", id);
        metadata.put("name", columnInfoBO.getName());
        metadata.put("tableName", tableInfoBO.getName());
        metadata.put("description", Optional.ofNullable(columnInfoBO.getDescription()).orElse(""));
        metadata.put("type", columnInfoBO.getType());
        metadata.put("primary", columnInfoBO.isPrimary());
        metadata.put("notnull", columnInfoBO.isNotnull());
        metadata.put("vectorType", "column");
        if (columnInfoBO.getSamples() != null) {
            metadata.put("samples", columnInfoBO.getSamples());
        }
        Document document = new Document(id, text, metadata);
        log.debug("Created column document with ID: {}", (Object)id);
        return document;
    }

    public Document convertTableToDocument(TableInfoBO tableInfoBO) {
        log.debug("Converting table to document: {}", (Object)tableInfoBO.getName());
        String text = Optional.ofNullable(tableInfoBO.getDescription()).orElse(tableInfoBO.getName());
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("schema", Optional.ofNullable(tableInfoBO.getSchema()).orElse(""));
        metadata.put("name", tableInfoBO.getName());
        metadata.put("description", Optional.ofNullable(tableInfoBO.getDescription()).orElse(""));
        metadata.put("foreignKey", Optional.ofNullable(tableInfoBO.getForeignKey()).orElse(""));
        metadata.put("primaryKey", Optional.ofNullable(tableInfoBO.getPrimaryKey()).orElse(""));
        metadata.put("vectorType", "table");
        Document document = new Document(tableInfoBO.getName(), text, metadata);
        log.debug("Created table document with ID: {}", (Object)tableInfoBO.getName());
        return document;
    }

    private Map<String, List<String>> buildForeignKeyMap(List<ForeignKeyInfoBO> foreignKeyInfoBOS) {
        HashMap<String, List<String>> foreignKeyMap = new HashMap<String, List<String>>();
        for (ForeignKeyInfoBO fk : foreignKeyInfoBOS) {
            String key = fk.getTable() + "." + fk.getColumn() + "=" + fk.getReferencedTable() + "." + fk.getReferencedColumn();
            foreignKeyMap.computeIfAbsent(fk.getTable(), k -> new ArrayList()).add(key);
            foreignKeyMap.computeIfAbsent(fk.getReferencedTable(), k -> new ArrayList()).add(key);
        }
        return foreignKeyMap;
    }

    public Boolean deleteDocuments(DeleteRequest deleteRequest) throws Exception {
        log.info("Starting delete operation with request: id={}, vectorType={}", (Object)deleteRequest.getId(), (Object)deleteRequest.getVectorType());
        try {
            if (deleteRequest.getId() != null && !deleteRequest.getId().isEmpty()) {
                log.debug("Deleting documents by ID: {}", (Object)deleteRequest.getId());
                this.vectorStore.delete(Arrays.asList(deleteRequest.getId()));
                log.info("Successfully deleted documents by ID");
            } else if (deleteRequest.getVectorType() != null && !deleteRequest.getVectorType().isEmpty()) {
                log.debug("Deleting documents by vectorType: {}", (Object)deleteRequest.getVectorType());
                FilterExpressionBuilder b = new FilterExpressionBuilder();
                Filter.Expression expression = b.eq("vectorType", (Object)deleteRequest.getVectorType()).build();
                List documents = this.vectorStore.similaritySearch(SearchRequest.builder().topK(Integer.MAX_VALUE).filterExpression(expression).build());
                if (documents != null && !documents.isEmpty()) {
                    log.info("Found {} documents to delete with vectorType: {}", (Object)documents.size(), (Object)deleteRequest.getVectorType());
                    this.vectorStore.delete(documents.stream().map(Document::getId).toList());
                    log.info("Successfully deleted {} documents", (Object)documents.size());
                } else {
                    log.info("No documents found to delete with vectorType: {}", (Object)deleteRequest.getVectorType());
                }
            } else {
                log.warn("Invalid delete request: either id or vectorType must be specified");
                throw new IllegalArgumentException("Either id or vectorType must be specified.");
            }
            return true;
        }
        catch (Exception e) {
            log.error("Failed to delete documents: {}", (Object)e.getMessage(), (Object)e);
            throw new Exception("Failed to delete collection data by filterExpression: " + e.getMessage(), e);
        }
    }

    @Override
    public List<Document> searchWithVectorType(com.alibaba.cloud.ai.request.SearchRequest searchRequestDTO) {
        log.debug("Searching with vectorType: {}, query: {}, topK: {}", new Object[]{searchRequestDTO.getVectorType(), searchRequestDTO.getQuery(), searchRequestDTO.getTopK()});
        FilterExpressionBuilder b = new FilterExpressionBuilder();
        Filter.Expression expression = b.eq("vectorType", (Object)searchRequestDTO.getVectorType()).build();
        ArrayList<Document> results = this.vectorStore.similaritySearch(SearchRequest.builder().query(searchRequestDTO.getQuery()).topK(searchRequestDTO.getTopK()).filterExpression(expression).build());
        if (results == null) {
            results = new ArrayList<Document>();
        }
        log.info("Search completed. Found {} documents for vectorType: {}", (Object)results.size(), (Object)searchRequestDTO.getVectorType());
        return results;
    }

    @Override
    public List<Document> searchWithFilter(com.alibaba.cloud.ai.request.SearchRequest searchRequestDTO) {
        log.debug("Searching with custom filter: vectorType={}, query={}, topK={}", new Object[]{searchRequestDTO.getVectorType(), searchRequestDTO.getQuery(), searchRequestDTO.getTopK()});
        FilterExpressionBuilder b = new FilterExpressionBuilder();
        Filter.Expression expression = b.eq("vectorType", (Object)searchRequestDTO.getVectorType()).build();
        ArrayList<Document> results = this.vectorStore.similaritySearch(SearchRequest.builder().query(searchRequestDTO.getQuery()).topK(searchRequestDTO.getTopK()).filterExpression(expression).build());
        if (results == null) {
            results = new ArrayList<Document>();
        }
        log.info("Search with filter completed. Found {} documents", (Object)results.size());
        return results;
    }

    @Override
    public List<Document> searchTableByNameAndVectorType(com.alibaba.cloud.ai.request.SearchRequest searchRequestDTO) {
        log.debug("Searching table by name and vectorType: name={}, vectorType={}, topK={}", new Object[]{searchRequestDTO.getName(), searchRequestDTO.getVectorType(), searchRequestDTO.getTopK()});
        FilterExpressionBuilder b = new FilterExpressionBuilder();
        Filter.Expression expression = b.and(b.eq("vectorType", (Object)searchRequestDTO.getVectorType()), b.eq("id", (Object)searchRequestDTO.getName())).build();
        ArrayList<Document> results = this.vectorStore.similaritySearch(SearchRequest.builder().topK(searchRequestDTO.getTopK()).filterExpression(expression).build());
        if (results == null) {
            results = new ArrayList<Document>();
        }
        log.info("Search by name completed. Found {} documents for name: {}", (Object)results.size(), (Object)searchRequestDTO.getName());
        return results;
    }

    public Boolean schemaForAgent(String agentId, SchemaInitRequest schemaInitRequest) throws Exception {
        log.info("Starting schema initialization for agent: {}, database: {}, schema: {}, tables: {}", new Object[]{agentId, schemaInitRequest.getDbConfig().getUrl(), schemaInitRequest.getDbConfig().getSchema(), schemaInitRequest.getTables()});
        DbConfig dbConfig = schemaInitRequest.getDbConfig();
        DbQueryParameter dqp = DbQueryParameter.from((DbConfig)dbConfig).setSchema(dbConfig.getSchema()).setTables(schemaInitRequest.getTables());
        this.agentVectorStoreManager.deleteDocumentsByType(agentId, "column");
        this.agentVectorStoreManager.deleteDocumentsByType(agentId, "table");
        log.debug("Fetching foreign keys from database for agent: {}", (Object)agentId);
        List foreignKeyInfoBOS = this.dbAccessor.showForeignKeys(dbConfig, dqp);
        log.debug("Found {} foreign keys for agent: {}", (Object)foreignKeyInfoBOS.size(), (Object)agentId);
        Map<String, List<String>> foreignKeyMap = this.buildForeignKeyMap(foreignKeyInfoBOS);
        log.debug("Fetching tables from database for agent: {}", (Object)agentId);
        List tableInfoBOS = this.dbAccessor.fetchTables(dbConfig, dqp);
        log.info("Found {} tables to process for agent: {}", (Object)tableInfoBOS.size(), (Object)agentId);
        for (TableInfoBO tableInfoBO : tableInfoBOS) {
            log.debug("Processing table: {} for agent: {}", (Object)tableInfoBO.getName(), (Object)agentId);
            this.processTable(tableInfoBO, dqp, dbConfig, foreignKeyMap);
        }
        log.debug("Converting columns to documents for agent: {}", (Object)agentId);
        List<Document> columnDocuments = tableInfoBOS.stream().flatMap(table -> {
            try {
                dqp.setTable(table.getName());
                return this.dbAccessor.showColumns(dbConfig, dqp).stream().map(column -> this.convertToDocumentForAgent(agentId, (TableInfoBO)table, (ColumnInfoBO)column));
            }
            catch (Exception e) {
                log.error("Error processing columns for table: {} and agent: {}", new Object[]{table.getName(), agentId, e});
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        log.info("Adding {} column documents to vector store for agent: {}", (Object)columnDocuments.size(), (Object)agentId);
        this.agentVectorStoreManager.addDocuments(agentId, columnDocuments);
        log.debug("Converting tables to documents for agent: {}", (Object)agentId);
        List<Document> tableDocuments = tableInfoBOS.stream().map(table -> this.convertTableToDocumentForAgent(agentId, (TableInfoBO)table)).collect(Collectors.toList());
        log.info("Adding {} table documents to vector store for agent: {}", (Object)tableDocuments.size(), (Object)agentId);
        this.agentVectorStoreManager.addDocuments(agentId, tableDocuments);
        log.info("Schema initialization completed successfully for agent: {}. Total documents added: {}", (Object)agentId, (Object)(columnDocuments.size() + tableDocuments.size()));
        return true;
    }

    private Document convertToDocumentForAgent(String agentId, TableInfoBO tableInfoBO, ColumnInfoBO columnInfoBO) {
        log.debug("Converting column to document for agent: {}, table={}, column={}", new Object[]{agentId, tableInfoBO.getName(), columnInfoBO.getName()});
        String text = Optional.ofNullable(columnInfoBO.getDescription()).orElse(columnInfoBO.getName());
        String id = agentId + ":" + tableInfoBO.getName() + "." + columnInfoBO.getName();
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("id", id);
        metadata.put("agentId", agentId);
        metadata.put("name", columnInfoBO.getName());
        metadata.put("tableName", tableInfoBO.getName());
        metadata.put("description", Optional.ofNullable(columnInfoBO.getDescription()).orElse(""));
        metadata.put("type", columnInfoBO.getType());
        metadata.put("primary", columnInfoBO.isPrimary());
        metadata.put("notnull", columnInfoBO.isNotnull());
        metadata.put("vectorType", "column");
        if (columnInfoBO.getSamples() != null) {
            metadata.put("samples", columnInfoBO.getSamples());
        }
        Document document = new Document(id, text, metadata);
        log.debug("Created column document with ID: {} for agent: {}", (Object)id, (Object)agentId);
        return document;
    }

    private Document convertTableToDocumentForAgent(String agentId, TableInfoBO tableInfoBO) {
        log.debug("Converting table to document for agent: {}, table: {}", (Object)agentId, (Object)tableInfoBO.getName());
        String text = Optional.ofNullable(tableInfoBO.getDescription()).orElse(tableInfoBO.getName());
        String id = agentId + ":" + tableInfoBO.getName();
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("agentId", agentId);
        metadata.put("schema", Optional.ofNullable(tableInfoBO.getSchema()).orElse(""));
        metadata.put("name", tableInfoBO.getName());
        metadata.put("description", Optional.ofNullable(tableInfoBO.getDescription()).orElse(""));
        metadata.put("foreignKey", Optional.ofNullable(tableInfoBO.getForeignKey()).orElse(""));
        metadata.put("primaryKey", Optional.ofNullable(tableInfoBO.getPrimaryKey()).orElse(""));
        metadata.put("vectorType", "table");
        Document document = new Document(id, text, metadata);
        log.debug("Created table document with ID: {} for agent: {}", (Object)id, (Object)agentId);
        return document;
    }

    public List<Document> searchWithVectorTypeForAgent(String agentId, com.alibaba.cloud.ai.request.SearchRequest searchRequestDTO) {
        log.debug("Searching for agent: {}, vectorType: {}, query: {}, topK: {}", new Object[]{agentId, searchRequestDTO.getVectorType(), searchRequestDTO.getQuery(), searchRequestDTO.getTopK()});
        List<Document> results = this.agentVectorStoreManager.similaritySearchWithFilter(agentId, searchRequestDTO.getQuery(), searchRequestDTO.getTopK(), searchRequestDTO.getVectorType());
        log.info("Search completed for agent: {}. Found {} documents for vectorType: {}", new Object[]{agentId, results.size(), searchRequestDTO.getVectorType()});
        return results;
    }

    public Boolean deleteDocumentsForAgent(String agentId, DeleteRequest deleteRequest) throws Exception {
        log.info("Starting delete operation for agent: {}, id={}, vectorType={}", new Object[]{agentId, deleteRequest.getId(), deleteRequest.getVectorType()});
        try {
            if (deleteRequest.getId() != null && !deleteRequest.getId().isEmpty()) {
                log.debug("Deleting documents by ID for agent: {}, ID: {}", (Object)agentId, (Object)deleteRequest.getId());
                this.agentVectorStoreManager.deleteDocuments(agentId, Arrays.asList(deleteRequest.getId()));
                log.info("Successfully deleted documents by ID for agent: {}", (Object)agentId);
            } else if (deleteRequest.getVectorType() != null && !deleteRequest.getVectorType().isEmpty()) {
                log.debug("Deleting documents by vectorType for agent: {}, vectorType: {}", (Object)agentId, (Object)deleteRequest.getVectorType());
                this.agentVectorStoreManager.deleteDocumentsByType(agentId, deleteRequest.getVectorType());
                log.info("Successfully deleted documents by vectorType for agent: {}", (Object)agentId);
            } else {
                log.warn("Invalid delete request for agent: {}: either id or vectorType must be specified", (Object)agentId);
                throw new IllegalArgumentException("Either id or vectorType must be specified.");
            }
            return true;
        }
        catch (Exception e) {
            log.error("Failed to delete documents for agent: {}: {}", new Object[]{agentId, e.getMessage(), e});
            throw new Exception("Failed to delete collection data for agent " + agentId + ": " + e.getMessage(), e);
        }
    }

    public AgentVectorStoreManager getAgentVectorStoreManager() {
        return this.agentVectorStoreManager;
    }

    @Override
    public List<Document> getDocumentsForAgent(String agentId, String query, String vectorType) {
        log.debug("Getting documents for agent: {}, query: {}, vectorType: {}", new Object[]{agentId, query, vectorType});
        if (agentId == null || agentId.trim().isEmpty()) {
            log.warn("AgentId is null or empty, falling back to global search");
            return this.getDocuments(query, vectorType);
        }
        try {
            List<Document> results = this.agentVectorStoreManager.similaritySearchWithFilter(agentId, query, 100, vectorType);
            log.info("Found {} documents for agent: {}, vectorType: {}", new Object[]{results.size(), agentId, vectorType});
            return results;
        }
        catch (Exception e) {
            log.error("Error getting documents for agent: {}, falling back to global search", (Object)agentId, (Object)e);
            return this.getDocuments(query, vectorType);
        }
    }
}

