/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.connector;

import com.alibaba.cloud.ai.connector.ResultSetConverter;
import com.alibaba.cloud.ai.connector.bo.ResultSetBO;
import com.alibaba.cloud.ai.connector.support.ResultSetBuilder;
import com.alibaba.cloud.ai.enums.DatabaseDialectEnum;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SqlExecutor {
    public static final Integer RESULT_SET_LIMIT = 1000;
    public static final Integer STATEMENT_TIMEOUT = 30;

    public static ResultSetBO executeSqlAndReturnObject(Connection connection, String schema, String sql) throws SQLException {
        try (Statement statement = connection.createStatement();){
            ResultSetBO resultSetBO;
            block13: {
                statement.setMaxRows(RESULT_SET_LIMIT);
                statement.setQueryTimeout(STATEMENT_TIMEOUT);
                DatabaseMetaData metaData = connection.getMetaData();
                String dialect = metaData.getDatabaseProductName();
                if (dialect.equals(DatabaseDialectEnum.POSTGRESQL.code) && StringUtils.isNotEmpty((CharSequence)schema)) {
                    statement.execute("set search_path = '" + schema + "';");
                }
                ResultSet rs = statement.executeQuery(sql);
                try {
                    resultSetBO = ResultSetBuilder.buildFrom(rs, schema);
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return resultSetBO;
        }
    }

    public static String[][] executeSqlAndReturnArr(Connection connection, String sql) throws SQLException {
        List<String[]> list = SqlExecutor.executeQuery(connection, sql);
        return (String[][])list.toArray((T[])new String[0][]);
    }

    public static String[][] executeSqlAndReturnArr(Connection connection, String databaseOrSchema, String sql) throws SQLException {
        List<String[]> list = SqlExecutor.executeQuery(connection, databaseOrSchema, sql);
        return (String[][])list.toArray((T[])new String[0][]);
    }

    private static List<String[]> executeQuery(Connection connection, String sql) throws SQLException {
        try (Statement statement = connection.createStatement();){
            List<String[]> list;
            block12: {
                ResultSet rs = statement.executeQuery(sql);
                try {
                    list = ResultSetConverter.convert(rs);
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return list;
        }
    }

    private static List<String[]> executeQuery(Connection connection, String databaseOrSchema, String sql) throws SQLException {
        String originalDb = connection.getCatalog();
        DatabaseMetaData metaData = connection.getMetaData();
        String dialect = metaData.getDatabaseProductName();
        try (Statement statement = connection.createStatement();){
            if (dialect.equals(DatabaseDialectEnum.MYSQL.code)) {
                if (StringUtils.isNotEmpty((CharSequence)databaseOrSchema)) {
                    statement.execute("use `" + databaseOrSchema + "`;");
                }
            } else if (dialect.equals(DatabaseDialectEnum.POSTGRESQL.code) && StringUtils.isNotEmpty((CharSequence)databaseOrSchema)) {
                statement.execute("set search_path = '" + databaseOrSchema + "';");
            }
            ResultSet rs = statement.executeQuery(sql);
            List<String[]> result = ResultSetConverter.convert(rs);
            if (StringUtils.isNotEmpty((CharSequence)databaseOrSchema) && dialect.equals(DatabaseDialectEnum.MYSQL.code)) {
                statement.execute("use `" + originalDb + "`;");
            }
            List<String[]> list = result;
            return list;
        }
    }
}

