/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.controller;

import com.alibaba.cloud.ai.entity.AgentDatasource;
import com.alibaba.cloud.ai.entity.Datasource;
import com.alibaba.cloud.ai.service.DatasourceService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/datasource"})
@CrossOrigin(origins={"*"})
public class DatasourceController {
    private final DatasourceService datasourceService;

    public DatasourceController(DatasourceService datasourceService) {
        this.datasourceService = datasourceService;
    }

    @GetMapping
    public ResponseEntity<List<Datasource>> getAllDatasources(@RequestParam(value="status", required=false) String status, @RequestParam(value="type", required=false) String type) {
        List datasources = status != null && !status.isEmpty() ? this.datasourceService.getDatasourcesByStatus(status) : (type != null && !type.isEmpty() ? this.datasourceService.getDatasourcesByType(type) : this.datasourceService.getAllDatasources());
        return ResponseEntity.ok((Object)datasources);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Datasource> getDatasourceById(@PathVariable Integer id) {
        Datasource datasource = this.datasourceService.getDatasourceById(id);
        if (datasource != null) {
            return ResponseEntity.ok((Object)datasource);
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping
    public ResponseEntity<Datasource> createDatasource(@RequestBody Datasource datasource) {
        try {
            Datasource created = this.datasourceService.createDatasource(datasource);
            return ResponseEntity.ok((Object)created);
        }
        catch (Exception e) {
            return ResponseEntity.badRequest().build();
        }
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Datasource> updateDatasource(@PathVariable Integer id, @RequestBody Datasource datasource) {
        try {
            Datasource updated = this.datasourceService.updateDatasource(id, datasource);
            return ResponseEntity.ok((Object)updated);
        }
        catch (Exception e) {
            return ResponseEntity.badRequest().build();
        }
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Map<String, Object>> deleteDatasource(@PathVariable Integer id) {
        try {
            this.datasourceService.deleteDatasource(id);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "\u6570\u636e\u6e90\u5220\u9664\u6210\u529f");
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", "\u5220\u9664\u5931\u8d25\uff1a" + e.getMessage());
            return ResponseEntity.badRequest().body(response);
        }
    }

    @PostMapping(value={"/{id}/test"})
    public ResponseEntity<Map<String, Object>> testConnection(@PathVariable Integer id) {
        try {
            boolean success = this.datasourceService.testConnection(id);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", success);
            response.put("message", success ? "\u8fde\u63a5\u6d4b\u8bd5\u6210\u529f" : "\u8fde\u63a5\u6d4b\u8bd5\u5931\u8d25");
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", "\u6d4b\u8bd5\u5931\u8d25\uff1a" + e.getMessage());
            return ResponseEntity.badRequest().body(response);
        }
    }

    @GetMapping(value={"/stats"})
    public ResponseEntity<Map<String, Object>> getDatasourceStats() {
        try {
            Map stats = this.datasourceService.getDatasourceStats();
            return ResponseEntity.ok((Object)stats);
        }
        catch (Exception e) {
            return ResponseEntity.badRequest().build();
        }
    }

    @GetMapping(value={"/agent/{agentId}"})
    public ResponseEntity<List<AgentDatasource>> getAgentDatasources(@PathVariable Integer agentId) {
        try {
            List agentDatasources = this.datasourceService.getAgentDatasources(agentId);
            return ResponseEntity.ok((Object)agentDatasources);
        }
        catch (Exception e) {
            return ResponseEntity.badRequest().build();
        }
    }

    @PostMapping(value={"/agent/{agentId}"})
    public ResponseEntity<Map<String, Object>> addDatasourceToAgent(@PathVariable Integer agentId, @RequestBody Map<String, Integer> request) {
        try {
            Integer datasourceId = request.get("datasourceId");
            if (datasourceId == null) {
                HashMap<String, Object> response = new HashMap<String, Object>();
                response.put("success", false);
                response.put("message", "\u6570\u636e\u6e90ID\u4e0d\u80fd\u4e3a\u7a7a");
                return ResponseEntity.badRequest().body(response);
            }
            AgentDatasource agentDatasource = this.datasourceService.addDatasourceToAgent(agentId, datasourceId);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "\u6570\u636e\u6e90\u6dfb\u52a0\u6210\u529f");
            response.put("data", agentDatasource);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", "\u6dfb\u52a0\u5931\u8d25\uff1a" + e.getMessage());
            return ResponseEntity.badRequest().body(response);
        }
    }

    @DeleteMapping(value={"/agent/{agentId}/{datasourceId}"})
    public ResponseEntity<Map<String, Object>> removeDatasourceFromAgent(@PathVariable Integer agentId, @PathVariable Integer datasourceId) {
        try {
            this.datasourceService.removeDatasourceFromAgent(agentId, datasourceId);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "\u6570\u636e\u6e90\u79fb\u9664\u6210\u529f");
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", "\u79fb\u9664\u5931\u8d25\uff1a" + e.getMessage());
            return ResponseEntity.badRequest().body(response);
        }
    }

    @PutMapping(value={"/agent/{agentId}/{datasourceId}/toggle"})
    public ResponseEntity<Map<String, Object>> toggleDatasourceForAgent(@PathVariable Integer agentId, @PathVariable Integer datasourceId, @RequestBody Map<String, Boolean> request) {
        try {
            Boolean isActive = request.get("isActive");
            if (isActive == null) {
                HashMap<String, Object> response = new HashMap<String, Object>();
                response.put("success", false);
                response.put("message", "\u6fc0\u6d3b\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
                return ResponseEntity.badRequest().body(response);
            }
            AgentDatasource agentDatasource = this.datasourceService.toggleDatasourceForAgent(agentId, datasourceId, isActive);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", isActive != false ? "\u6570\u636e\u6e90\u5df2\u542f\u7528" : "\u6570\u636e\u6e90\u5df2\u7981\u7528");
            response.put("data", agentDatasource);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", "\u64cd\u4f5c\u5931\u8d25\uff1a" + e.getMessage());
            return ResponseEntity.badRequest().body(response);
        }
    }
}

