/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.controller;

import com.alibaba.cloud.ai.entity.SemanticModel;
import com.alibaba.cloud.ai.entity.SemanticModelDTO;
import com.alibaba.cloud.ai.service.SemanticModelPersistenceService;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/fields"})
public class SemanticModelPersistenceController {
    private final SemanticModelPersistenceService semanticModelPersistenceService;

    public SemanticModelPersistenceController(SemanticModelPersistenceService semanticModelPersistenceService) {
        this.semanticModelPersistenceService = semanticModelPersistenceService;
    }

    @PostMapping(value={"/add"})
    public ResponseEntity<Void> addField(@RequestBody SemanticModelDTO semanticModelDTO) {
        this.semanticModelPersistenceService.addField(semanticModelDTO);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/addList"})
    public ResponseEntity<Void> addFields(@RequestBody List<SemanticModelDTO> semanticModelDTOS) {
        this.semanticModelPersistenceService.addFields(semanticModelDTOS);
        return ResponseEntity.ok().build();
    }

    @PutMapping(value={"/enable"})
    public ResponseEntity<Void> enableFields(@RequestBody List<Long> ids) {
        this.semanticModelPersistenceService.enableFields(ids);
        return ResponseEntity.ok().build();
    }

    @PutMapping(value={"/disable"})
    public ResponseEntity<Void> disableFields(@RequestBody List<Long> ids) {
        this.semanticModelPersistenceService.disableFields(ids);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/agent/{agentId}"})
    public ResponseEntity<List<SemanticModel>> getFieldsByAgentId(@PathVariable Long agentId) {
        List<SemanticModel> fields = this.semanticModelPersistenceService.getFieldByAgentId(agentId);
        return ResponseEntity.ok(fields);
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<List<SemanticModel>> searchFields(@RequestParam String content) {
        List<SemanticModel> fields = this.semanticModelPersistenceService.searchFields(content);
        return ResponseEntity.ok(fields);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteFieldById(@PathVariable long id) {
        this.semanticModelPersistenceService.deleteFieldById(id);
        return ResponseEntity.ok().build();
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Void> updateField(@PathVariable long id, @RequestBody SemanticModelDTO semanticModelDTO) {
        this.semanticModelPersistenceService.updateField(semanticModelDTO, id);
        return ResponseEntity.ok().build();
    }
}

