/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.prompt;

import java.util.List;
import java.util.Map;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.chat.prompt.PromptTemplate;
import org.springframework.ai.chat.prompt.PromptTemplateActions;
import org.springframework.ai.chat.prompt.PromptTemplateMessageActions;
import org.springframework.ai.content.Media;
import org.springframework.core.io.Resource;

public class ConfigurablePromptTemplate
implements PromptTemplateActions,
PromptTemplateMessageActions {
    private final PromptTemplate promptTemplate;
    private final String name;

    ConfigurablePromptTemplate(String name, Resource resource) {
        this(name, new PromptTemplate(resource));
    }

    ConfigurablePromptTemplate(String name, String template) {
        this(name, new PromptTemplate(template));
    }

    ConfigurablePromptTemplate(String name, String template, Map<String, Object> model) {
        this(name, PromptTemplate.builder().template(template).variables(model).build());
    }

    ConfigurablePromptTemplate(String name, Resource resource, Map<String, Object> model) {
        this(name, PromptTemplate.builder().resource(resource).variables(model).build());
    }

    ConfigurablePromptTemplate(String name, PromptTemplate promptTemplate) {
        this.promptTemplate = promptTemplate;
        this.name = name;
    }

    public Prompt create() {
        return this.promptTemplate.create();
    }

    public Prompt create(ChatOptions modelOptions) {
        return this.promptTemplate.create(modelOptions);
    }

    public Prompt create(Map<String, Object> model) {
        return this.promptTemplate.create(model);
    }

    public Prompt create(Map<String, Object> model, ChatOptions modelOptions) {
        return this.promptTemplate.create(model, modelOptions);
    }

    public Message createMessage() {
        return this.promptTemplate.createMessage();
    }

    public Message createMessage(List<Media> mediaList) {
        return this.promptTemplate.createMessage(mediaList);
    }

    public Message createMessage(Map<String, Object> model) {
        return this.promptTemplate.createMessage(model);
    }

    public String render() {
        return this.promptTemplate.render();
    }

    public String render(Map<String, Object> model) {
        return this.promptTemplate.render(model);
    }
}

