/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.prompt;

import com.alibaba.cloud.ai.prompt.ConfigurablePromptTemplate;
import com.alibaba.cloud.ai.prompt.PromptTemplateBuilderConfigure;
import com.alibaba.cloud.nacos.annotation.NacosConfigListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.prompt.PromptTemplate;
import org.springframework.core.io.Resource;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ConfigurablePromptTemplateFactory {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurablePromptTemplateFactory.class);
    private final Map<String, ConfigurablePromptTemplate> templates = new ConcurrentHashMap<String, ConfigurablePromptTemplate>();
    private final PromptTemplateBuilderConfigure promptTemplateBuilderConfigure;

    public ConfigurablePromptTemplateFactory(PromptTemplateBuilderConfigure promptTemplateBuilderConfigure) {
        this.promptTemplateBuilderConfigure = promptTemplateBuilderConfigure;
    }

    public ConfigurablePromptTemplate create(String name, Resource resource) {
        return this.templates.computeIfAbsent(name, k -> new ConfigurablePromptTemplate(name, resource));
    }

    public ConfigurablePromptTemplate create(String name, String template) {
        return this.templates.computeIfAbsent(name, k -> new ConfigurablePromptTemplate(name, template));
    }

    public ConfigurablePromptTemplate create(String name, String template, Map<String, Object> model) {
        return this.templates.computeIfAbsent(name, k -> new ConfigurablePromptTemplate(name, template, model));
    }

    public ConfigurablePromptTemplate create(String name, Resource resource, Map<String, Object> model) {
        return this.templates.computeIfAbsent(name, k -> new ConfigurablePromptTemplate(name, resource, model));
    }

    public ConfigurablePromptTemplate create(String name, PromptTemplate promptTemplate) {
        return this.templates.computeIfAbsent(name, k -> new ConfigurablePromptTemplate(name, promptTemplate));
    }

    @NacosConfigListener(dataId="spring.ai.alibaba.configurable.prompt", group="DEFAULT_GROUP", initNotify=true)
    protected void onConfigChange(List<ConfigurablePromptTemplateModel> configList) {
        if (CollectionUtils.isEmpty(configList)) {
            return;
        }
        for (ConfigurablePromptTemplateModel configuration : configList) {
            if (!StringUtils.hasText((String)configuration.name()) || !StringUtils.hasText((String)configuration.template())) continue;
            PromptTemplate.Builder promptTemplateBuilder = this.promptTemplateBuilderConfigure.configure(PromptTemplate.builder().template(configuration.template()).variables(configuration.model() == null ? new HashMap() : configuration.model()));
            this.templates.put(configuration.name(), new ConfigurablePromptTemplate(configuration.name(), promptTemplateBuilder.build()));
            logger.info("OnPromptTemplateConfigChange,templateName:{},template:{},model:{}", new Object[]{configuration.name(), configuration.template(), configuration.model()});
        }
    }

    public ConfigurablePromptTemplate getTemplate(String name) {
        return this.templates.get(name);
    }

    public record ConfigurablePromptTemplateModel(String name, String template, Map<String, Object> model) {
    }
}

