/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.common;

import com.alibaba.cloud.ai.toolcalling.common.CommonToolCallConstants;
import com.alibaba.cloud.ai.toolcalling.common.CommonToolCallProperties;
import com.alibaba.cloud.ai.toolcalling.common.JsonParseTool;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.util.Timeout;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;

public class RestClientTool {
    private final RestClient restClient;
    private final JsonParseTool jsonParseTool;
    private final CommonToolCallProperties properties;

    private HttpComponentsClientHttpRequestFactory createRequestFactory() {
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(Timeout.of((long)this.properties.getNetworkTimeout().intValue(), (TimeUnit)TimeUnit.MINUTES)).setConnectTimeout(Timeout.of((long)this.properties.getNetworkTimeout().intValue(), (TimeUnit)TimeUnit.MINUTES)).setResponseTimeout(Timeout.of((long)this.properties.getNetworkTimeout().intValue(), (TimeUnit)TimeUnit.MINUTES)).build();
        CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();
        return new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
    }

    private RestClientTool(Consumer<HttpHeaders> httpHeadersConsumer, ResponseErrorHandler errorHandler, CommonToolCallProperties properties, JsonParseTool jsonParseTool) {
        this.jsonParseTool = jsonParseTool;
        this.properties = properties;
        this.restClient = RestClient.builder().requestFactory((ClientHttpRequestFactory)this.createRequestFactory()).baseUrl(properties.getBaseUrl()).defaultHeaders(httpHeadersConsumer).defaultStatusHandler(errorHandler).build();
    }

    public String get(String uri, MultiValueMap<String, String> params, Map<String, ?> variables) {
        return (String)this.restClient.get().uri(uriBuilder -> uriBuilder.path(uri).queryParams(params).build(variables)).retrieve().body(String.class);
    }

    public String get(String uri, MultiValueMap<String, String> params) {
        return this.get(uri, params, new HashMap());
    }

    public String get(String uri, Map<String, ?> variables) {
        return this.get(uri, (MultiValueMap<String, String>)new LinkedMultiValueMap(), variables);
    }

    public String get(String uri) {
        return this.get(uri, new HashMap());
    }

    public <T> String post(String uri, MultiValueMap<String, String> params, Map<String, ?> variables, T value, MediaType mediaType) {
        return (String)((RestClient.RequestBodySpec)this.restClient.post().uri(uriBuilder -> uriBuilder.path(uri).queryParams(params).build(variables))).contentType(mediaType).body(value).retrieve().body(String.class);
    }

    public <T> String post(String uri, MultiValueMap<String, String> params, Map<String, ?> variables, T value) {
        try {
            return this.post(uri, params, variables, this.jsonParseTool.objectToJson(value), MediaType.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Serialization failed", e);
        }
    }

    public <T> String post(String uri, Map<String, ?> variables, T value) {
        return this.post(uri, (MultiValueMap<String, String>)new LinkedMultiValueMap(), variables, value);
    }

    public <T> String post(String uri, MultiValueMap<String, String> params, T value) {
        return this.post(uri, params, new HashMap(), value);
    }

    public <T> String post(String uri, T value) {
        return this.post(uri, new HashMap(), value);
    }

    public static Builder builder(JsonParseTool jsonParseTool, CommonToolCallProperties properties) {
        return new Builder(jsonParseTool, properties);
    }

    public RestClient getRestClient() {
        return this.restClient;
    }

    public static class Builder {
        private final JsonParseTool jsonParseTool;
        private final CommonToolCallProperties properties;
        private ResponseErrorHandler errorHandler;
        private Consumer<HttpHeaders> httpHeadersConsumer;

        Builder(JsonParseTool jsonParseTool, CommonToolCallProperties properties) {
            this.jsonParseTool = jsonParseTool;
            this.properties = properties;
            this.errorHandler = CommonToolCallConstants.DEFAULT_RESTCLIENT_ERROR_HANDLER;
            this.httpHeadersConsumer = httpHeaders -> {};
        }

        public Builder errorHandler(ResponseErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public Builder httpHeadersConsumer(Consumer<HttpHeaders> httpHeadersConsumer) {
            this.httpHeadersConsumer = httpHeadersConsumer;
            return this;
        }

        public RestClientTool build() {
            return new RestClientTool(this.httpHeadersConsumer, this.errorHandler, this.properties, this.jsonParseTool);
        }
    }
}

