/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos;

import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.alibaba.cloud.nacos.diagnostics.analyzer.NacosConnectionFailureException;
import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosConfigManager {
    private static final Logger log = LoggerFactory.getLogger(NacosConfigManager.class);
    private static ConfigService service;
    private static NacosConfigManager INSTANCE;
    private NacosConfigProperties nacosConfigProperties;

    public NacosConfigManager(NacosConfigProperties nacosConfigProperties) {
        this.nacosConfigProperties = nacosConfigProperties;
    }

    public static NacosConfigManager getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NacosConfigManager getInstance(NacosConfigProperties properties) {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        Class<NacosConfigManager> clazz = NacosConfigManager.class;
        synchronized (NacosConfigManager.class) {
            if (INSTANCE == null) {
                INSTANCE = new NacosConfigManager(properties);
                INSTANCE.createConfigService(properties);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private ConfigService createConfigService(NacosConfigProperties nacosConfigProperties) {
        try {
            if (Objects.isNull(service)) {
                service = NacosFactory.createConfigService((Properties)nacosConfigProperties.assembleConfigServiceProperties());
            }
        }
        catch (NacosException e) {
            log.error(e.getMessage());
            throw new NacosConnectionFailureException(nacosConfigProperties.getServerAddr(), e.getMessage(), e);
        }
        return service;
    }

    public ConfigService getConfigService() {
        if (Objects.isNull(service)) {
            this.createConfigService(this.nacosConfigProperties);
        }
        return service;
    }

    public NacosConfigProperties getNacosConfigProperties() {
        return this.nacosConfigProperties;
    }
}

