/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.sidecar;

import com.alibaba.cloud.sidecar.SidecarDiscoveryClient;
import com.alibaba.cloud.sidecar.SidecarHealthChecker;
import com.alibaba.cloud.sidecar.SidecarHealthIndicator;
import com.alibaba.cloud.sidecar.SidecarProperties;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.web.client.RestTemplate;

@Configuration(proxyBeanMethods=false)
public class SidecarAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }

    @Bean
    @ConditionalOnEnabledHealthIndicator(value="sidecar")
    public SidecarHealthIndicator sidecarHealthIndicator(SidecarProperties sidecarProperties, RestTemplate restTemplate) {
        return new SidecarHealthIndicator(sidecarProperties, restTemplate);
    }

    @Bean
    public SidecarHealthChecker sidecarHealthChecker(SidecarDiscoveryClient sidecarDiscoveryClient, SidecarHealthIndicator sidecarHealthIndicator, SidecarProperties sidecarProperties, ConfigurableEnvironment environment) {
        SidecarHealthChecker cleaner = new SidecarHealthChecker(sidecarDiscoveryClient, (HealthIndicator)sidecarHealthIndicator, sidecarProperties, environment);
        cleaner.check();
        return cleaner;
    }
}

