/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.sidecar.consul;

import com.alibaba.cloud.sidecar.SidecarProperties;
import com.ecwid.consul.v1.agent.model.NewService;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationProperties;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.discovery.HeartbeatProperties;
import org.springframework.cloud.consul.serviceregistry.ConsulAutoRegistration;
import org.springframework.cloud.consul.serviceregistry.ConsulManagementRegistrationCustomizer;
import org.springframework.cloud.consul.serviceregistry.ConsulRegistrationCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class SidecarConsulAutoRegistration
extends ConsulAutoRegistration {
    public SidecarConsulAutoRegistration(NewService service, AutoServiceRegistrationProperties autoServiceRegistrationProperties, ConsulDiscoveryProperties properties, ApplicationContext context, HeartbeatProperties heartbeatProperties, List<ConsulManagementRegistrationCustomizer> managementRegistrationCustomizers) {
        super(service, autoServiceRegistrationProperties, properties, context, heartbeatProperties, managementRegistrationCustomizers);
    }

    public static ConsulAutoRegistration registration(AutoServiceRegistrationProperties autoServiceRegistrationProperties, ConsulDiscoveryProperties properties, ApplicationContext context, List<ConsulRegistrationCustomizer> registrationCustomizers, List<ConsulManagementRegistrationCustomizer> managementRegistrationCustomizers, HeartbeatProperties heartbeatProperties, SidecarProperties sidecarProperties) {
        NewService service = new NewService();
        String appName = SidecarConsulAutoRegistration.getAppName((ConsulDiscoveryProperties)properties, (Environment)context.getEnvironment());
        service.setId(SidecarConsulAutoRegistration.getInstanceId(sidecarProperties, context.getEnvironment()));
        if (!properties.isPreferAgentAddress()) {
            service.setAddress(sidecarProperties.getIp());
        }
        service.setName(SidecarConsulAutoRegistration.normalizeForDns((String)appName));
        service.setTags(new ArrayList(properties.getTags()));
        service.setEnableTagOverride(properties.getEnableTagOverride());
        service.setMeta(SidecarConsulAutoRegistration.getMetadata(properties));
        if (sidecarProperties.getPort() != null && sidecarProperties.getPort() > 0) {
            service.setPort(properties.getPort());
        } else if (properties.getPort() != null && properties.getPort() > 0) {
            service.setPort(properties.getPort());
        } else if (context.getEnvironment().getProperty("server.port") != null) {
            service.setPort(Integer.valueOf(context.getEnvironment().getProperty("server.port")));
        }
        if (service.getPort() != null) {
            SidecarConsulAutoRegistration.setCheck((NewService)service, (AutoServiceRegistrationProperties)autoServiceRegistrationProperties, (ConsulDiscoveryProperties)properties, (ApplicationContext)context, (HeartbeatProperties)heartbeatProperties);
        }
        ConsulAutoRegistration registration = new ConsulAutoRegistration(service, autoServiceRegistrationProperties, properties, context, heartbeatProperties, managementRegistrationCustomizers);
        SidecarConsulAutoRegistration.customize(registrationCustomizers, (ConsulAutoRegistration)registration);
        return registration;
    }

    private static Map<String, String> getMetadata(ConsulDiscoveryProperties properties) {
        LinkedHashMap<String, String> metadata = new LinkedHashMap<String, String>();
        if (!CollectionUtils.isEmpty((Map)properties.getMetadata())) {
            metadata.putAll(properties.getMetadata());
        }
        if (StringUtils.hasLength((String)properties.getInstanceZone())) {
            metadata.put(properties.getDefaultZoneMetadataName(), properties.getInstanceZone());
        }
        if (StringUtils.hasLength((String)properties.getInstanceGroup())) {
            metadata.put("group", properties.getInstanceGroup());
        }
        metadata.put("secure", Boolean.toString(properties.getScheme().equalsIgnoreCase("https")));
        return metadata;
    }

    public static String getInstanceId(SidecarProperties sidecarProperties, Environment environment) {
        return String.format("%s-%s-%s", environment.getProperty("spring.application.name"), sidecarProperties.getIp(), sidecarProperties.getPort());
    }
}

